/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.factory;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authorization.AuthorizationEvaluator;
import org.apache.rocketmq.auth.authorization.context.AuthorizationContext;
import org.apache.rocketmq.auth.authorization.manager.AuthorizationMetadataManager;
import org.apache.rocketmq.auth.authorization.manager.AuthorizationMetadataManagerImpl;
import org.apache.rocketmq.auth.authorization.provider.AuthorizationMetadataProvider;
import org.apache.rocketmq.auth.authorization.provider.AuthorizationProvider;
import org.apache.rocketmq.auth.authorization.provider.DefaultAuthorizationProvider;
import org.apache.rocketmq.auth.authorization.strategy.AuthorizationStrategy;
import org.apache.rocketmq.auth.authorization.strategy.StatelessAuthorizationStrategy;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class AuthorizationFactory {
    private static final Map<String, Object> INSTANCE_MAP = new HashMap<String, Object>();
    private static final String PROVIDER_PREFIX = "PROVIDER_";
    private static final String METADATA_PROVIDER_PREFIX = "METADATA_PROVIDER_";
    private static final String EVALUATOR_PREFIX = "EVALUATOR_";

    public static AuthorizationProvider<AuthorizationContext> getProvider(AuthConfig config) {
        if (config == null) {
            return null;
        }
        return AuthorizationFactory.computeIfAbsent(PROVIDER_PREFIX + config.getConfigName(), key -> {
            try {
                Class clazz = DefaultAuthorizationProvider.class;
                if (StringUtils.isNotBlank((CharSequence)config.getAuthorizationProvider())) {
                    clazz = Class.forName(config.getAuthorizationProvider());
                }
                return (AuthorizationProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load the authorization provider.", e);
            }
        });
    }

    public static AuthorizationMetadataProvider getMetadataProvider(AuthConfig config) {
        return AuthorizationFactory.getMetadataProvider(config, null);
    }

    public static AuthorizationMetadataManager getMetadataManager(AuthConfig config) {
        return new AuthorizationMetadataManagerImpl(config);
    }

    public static AuthorizationMetadataProvider getMetadataProvider(AuthConfig config, Supplier<?> metadataService) {
        if (config == null) {
            return null;
        }
        return AuthorizationFactory.computeIfAbsent(METADATA_PROVIDER_PREFIX + config.getConfigName(), key -> {
            try {
                if (StringUtils.isBlank((CharSequence)config.getAuthorizationMetadataProvider())) {
                    return null;
                }
                Class<?> clazz = Class.forName(config.getAuthorizationMetadataProvider());
                AuthorizationMetadataProvider result = (AuthorizationMetadataProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                result.initialize(config, metadataService);
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load the authorization metadata provider.", e);
            }
        });
    }

    public static AuthorizationEvaluator getEvaluator(AuthConfig config) {
        return AuthorizationFactory.computeIfAbsent(EVALUATOR_PREFIX + config.getConfigName(), key -> new AuthorizationEvaluator(config));
    }

    public static AuthorizationEvaluator getEvaluator(AuthConfig config, Supplier<?> metadataService) {
        return AuthorizationFactory.computeIfAbsent(EVALUATOR_PREFIX + config.getConfigName(), key -> new AuthorizationEvaluator(config, metadataService));
    }

    public static AuthorizationStrategy getStrategy(AuthConfig config, Supplier<?> metadataService) {
        try {
            Class clazz = StatelessAuthorizationStrategy.class;
            if (StringUtils.isNotBlank((CharSequence)config.getAuthorizationStrategy())) {
                clazz = Class.forName(config.getAuthorizationStrategy());
            }
            return (AuthorizationStrategy)clazz.getDeclaredConstructor(AuthConfig.class, Supplier.class).newInstance(config, metadataService);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<AuthorizationContext> newContexts(AuthConfig config, Metadata metadata, GeneratedMessageV3 message) {
        AuthorizationProvider<AuthorizationContext> authorizationProvider = AuthorizationFactory.getProvider(config);
        if (authorizationProvider == null) {
            return null;
        }
        return authorizationProvider.newContexts(metadata, message);
    }

    public static List<AuthorizationContext> newContexts(AuthConfig config, ChannelHandlerContext context, RemotingCommand command) {
        AuthorizationProvider<AuthorizationContext> authorizationProvider = AuthorizationFactory.getProvider(config);
        if (authorizationProvider == null) {
            return null;
        }
        return authorizationProvider.newContexts(context, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> V computeIfAbsent(String key, Function<String, ? extends V> function) {
        Object result = null;
        if (INSTANCE_MAP.containsKey(key)) {
            result = INSTANCE_MAP.get(key);
        }
        if (result == null) {
            Map<String, Object> map = INSTANCE_MAP;
            synchronized (map) {
                if (INSTANCE_MAP.containsKey(key)) {
                    result = INSTANCE_MAP.get(key);
                }
                if (result == null && (result = function.apply(key)) != null) {
                    INSTANCE_MAP.put(key, result);
                }
            }
        }
        return (V)(result != null ? result : null);
    }
}

