/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt.eis;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemorySessionDAO
extends AbstractSessionDAO {
    private static final Logger log = LoggerFactory.getLogger(MemorySessionDAO.class);
    private ConcurrentMap<Serializable, Session> sessions = new ConcurrentHashMap<Serializable, Session>();

    @Override
    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.storeSession(sessionId, session);
        return sessionId;
    }

    protected Session storeSession(Serializable id, Session session) {
        if (id == null) {
            throw new NullPointerException("id argument cannot be null.");
        }
        return this.sessions.putIfAbsent(id, session);
    }

    @Override
    protected Session doReadSession(Serializable sessionId) {
        return (Session)this.sessions.get(sessionId);
    }

    @Override
    public void update(Session session) throws UnknownSessionException {
        this.storeSession(session.getId(), session);
    }

    @Override
    public void delete(Session session) {
        if (session == null) {
            throw new NullPointerException("session argument cannot be null.");
        }
        Serializable id = session.getId();
        if (id != null) {
            this.sessions.remove(id);
        }
    }

    @Override
    public Collection<Session> getActiveSessions() {
        Collection values = this.sessions.values();
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(values);
    }
}

