/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.ShutdownableService;
import org.apache.camel.impl.InterceptSendToEndpointProcessor;
import org.apache.camel.impl.InterceptSendToEndpointServicePoolProcessor;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToEndpoint
implements Endpoint,
ShutdownableService {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToEndpoint.class);
    private final Endpoint delegate;
    private Processor detour;
    private boolean skip;

    public InterceptSendToEndpoint(Endpoint destination, boolean skip) {
        this.delegate = destination;
        this.skip = skip;
    }

    public void setDetour(Processor detour) {
        this.detour = detour;
    }

    public Processor getDetour() {
        return this.detour;
    }

    public Endpoint getDelegate() {
        return this.delegate;
    }

    @Override
    public String getEndpointUri() {
        return this.delegate.getEndpointUri();
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.delegate.getEndpointConfiguration();
    }

    @Override
    public String getEndpointKey() {
        return this.delegate.getEndpointKey();
    }

    @Override
    public Exchange createExchange() {
        return this.delegate.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.delegate.createExchange(pattern);
    }

    @Override
    @Deprecated
    public Exchange createExchange(Exchange exchange) {
        return this.delegate.createExchange(exchange);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.delegate.getCamelContext();
    }

    @Override
    public Producer createProducer() throws Exception {
        Producer producer = this.delegate.createProducer();
        if (producer instanceof ServicePoolAware) {
            return new InterceptSendToEndpointServicePoolProcessor(this, this.delegate, producer, this.skip);
        }
        return new InterceptSendToEndpointProcessor(this, this.delegate, producer, this.skip);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return this.delegate.createConsumer(processor);
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        return this.delegate.createPollingConsumer();
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        this.delegate.configureProperties(options);
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.delegate.setCamelContext(context);
    }

    @Override
    public boolean isLenientProperties() {
        return this.delegate.isLenientProperties();
    }

    @Override
    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startServices(this.detour, this.delegate);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.delegate, this.detour);
    }

    @Override
    public void shutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.delegate, this.detour);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

