/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

@Deprecated
public class ServerCookie
implements Serializable {
    private static final String tspecials = ",; ";
    private static final String tspecials2 = "()<>@,;:\\\"/[]?={} \t";
    private static final Locale LOCALE_US = Locale.US;
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final DateFormat OLD_COOKIE_FORMAT = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", LOCALE_US);
    private static final String ancientDate;

    public static boolean isToken(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCTL(String value, int version) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' || c == '\t') continue;
            return true;
        }
        return false;
    }

    public static boolean isToken2(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (tspecials2.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkName(String name) {
        return ServerCookie.isToken(name) && !name.equalsIgnoreCase("Comment") && !name.equalsIgnoreCase("Discard") && !name.equalsIgnoreCase("Domain") && !name.equalsIgnoreCase("Expires") && !name.equalsIgnoreCase("Max-Age") && !name.equalsIgnoreCase("Path") && !name.equalsIgnoreCase("Secure") && !name.equalsIgnoreCase("Version");
    }

    public static String getCookieHeaderName(int version) {
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatOldCookie(Date d) {
        String ocf = null;
        DateFormat dateFormat = OLD_COOKIE_FORMAT;
        synchronized (dateFormat) {
            ocf = OLD_COOKIE_FORMAT.format(d);
        }
        return ocf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatOldCookie(Date d, StringBuffer sb, FieldPosition fp) {
        DateFormat dateFormat = OLD_COOKIE_FORMAT;
        synchronized (dateFormat) {
            OLD_COOKIE_FORMAT.format(d, sb, fp);
        }
    }

    public static void appendCookieValue(StringBuilder headerBuf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure, boolean httpOnly, SameSiteAttributeValue sameSite) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("=");
        buf.append(value);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                buf.append(comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            buf.append(domain);
        }
        if (maxAge >= 0) {
            buf.append("; Expires=");
            if (maxAge == 0) {
                buf.append(ancientDate);
            } else {
                ServerCookie.formatOldCookie(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
            }
            buf.append("; Max-Age=");
            buf.append(maxAge);
        }
        if (path != null) {
            buf.append("; Path=");
            buf.append(path);
        }
        if (sameSite != null) {
            buf.append("; SameSite=");
            buf.append(sameSite.toString());
        }
        if (isSecure) {
            buf.append("; Secure");
        }
        if (httpOnly) {
            buf.append("; HttpOnly");
        }
        headerBuf.append(buf);
    }

    @Deprecated
    public static void maybeQuote(int version, StringBuffer buf, String value) {
        if (ServerCookie.isToken(value)) {
            buf.append(value);
        } else {
            buf.append('\"');
            buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
            buf.append('\"');
        }
    }

    public static boolean alreadyQuoted(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    public static void maybeQuote2(int version, StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else {
            if (ServerCookie.containsCTL(value, version)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (ServerCookie.alreadyQuoted(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 1, value.length() - 1));
                buf.append('\"');
            } else if (version == 0 && !ServerCookie.isToken(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else if (version == 1 && !ServerCookie.isToken2(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else {
                buf.append(value);
            }
        }
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    static {
        OLD_COOKIE_FORMAT.setTimeZone(GMT_ZONE);
        ancientDate = ServerCookie.formatOldCookie(new Date(10000L));
    }

    public static enum SameSiteAttributeValue {
        NONE("None"),
        LAX("Lax"),
        STRICT("Strict");

        private final String specValue;

        private SameSiteAttributeValue(String specValue) {
            this.specValue = specValue;
        }

        public String toString() {
            return this.specValue;
        }
    }
}

