/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.federated.client.keycloak;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.custos.core.exception.UnauthorizedException;
import org.apache.custos.service.federated.client.keycloak.KeycloakClientSecret;
import org.apache.custos.service.federated.client.keycloak.KeycloakUtils;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeycloakClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakClient.class);
    private static final int ACCESS_TOKEN_LIFE_SPAN = 1800;
    private static final int SESSION_IDLE_TIMEOUT = 3600;
    private final ObjectMapper objectMapper;
    @Value(value="${iam.server.client.id:admin-cli}")
    private String clientId;
    @Value(value="${iam.server.url}")
    private String iamServerURL;
    @Value(value="${iam.server.admin.username}")
    private String superAdminUserName;
    @Value(value="${iam.server.admin.password}")
    private String superAdminPassword;
    @Value(value="${iam.server.super.admin.realm.id:master}")
    private String superAdminRealmID;
    @Value(value="${iam.federated.cilogon.authorization.endpoint:https://cilogon.org/authorize}")
    private String ciLogonAuthorizationEndpoint;
    @Value(value="${iam.federated.cilogon.token.endpoint:https://cilogon.org/oauth2/token}")
    private String ciLogonTokenEndpoint;
    @Value(value="${iam.federated.cilogon.token.userinfo.endpoint:https://cilogon.org/oauth2/userinfo}")
    private String ciLogonUserInfoEndpoint;
    @Value(value="${iam.federated.cilogon.issuer:https://cilogon.org}")
    private String ciLogonIssuerUri;
    @Value(value="${iam.federated.cilogon.jwksUri:https://cilogon.org/oauth2/certs}")
    private String jwksUri;

    public KeycloakClient(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void createRealm(String realmId, String displayName) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            RealmRepresentation newRealmDetails = new RealmRepresentation();
            newRealmDetails.setEnabled(Boolean.valueOf(true));
            newRealmDetails.setId(realmId);
            newRealmDetails.setDisplayName(displayName);
            newRealmDetails.setRealm(realmId);
            newRealmDetails.setLoginWithEmailAllowed(Boolean.valueOf(false));
            newRealmDetails.setDuplicateEmailsAllowed(Boolean.valueOf(true));
            newRealmDetails.setAccessTokenLifespan(Integer.valueOf(1800));
            newRealmDetails.setSsoSessionIdleTimeout(Integer.valueOf(3600));
            RealmRepresentation realmWithRoles = this.createDefaultRoles(newRealmDetails);
            client.realms().create(realmWithRoles);
        }
        catch (Exception ex) {
            String msg = "Error creating Realm in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public void updateRealm(String realmId, String displayName) {
        block9: {
            try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
                RealmResource realmResource = client.realm(realmId);
                if (realmResource != null) {
                    RealmRepresentation newRealmDetails = realmResource.toRepresentation();
                    newRealmDetails.setId(realmId);
                    newRealmDetails.setDisplayName(displayName);
                    newRealmDetails.setRealm(realmId);
                    realmResource.update(newRealmDetails);
                    break block9;
                }
                LOGGER.error("Realm not found");
                throw new RuntimeException("Realm not found");
            }
            catch (Exception ex) {
                String msg = "Error creating Realm in Keycloak Server, reason: " + ex.getMessage();
                LOGGER.error(msg, (Throwable)ex);
                throw new RuntimeException(msg, ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createRealmAdminAccount(String realmId, String adminUsername, String adminFirstname, String adminLastname, String adminEmail, String adminPassword) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            UserRepresentation user = new UserRepresentation();
            user.setUsername(adminUsername);
            user.setFirstName(adminFirstname);
            user.setLastName(adminLastname);
            user.setEmail(adminEmail);
            user.setEmailVerified(Boolean.valueOf(true));
            user.setEnabled(Boolean.valueOf(true));
            Response httpResponse = client.realm(realmId).users().create(user);
            LOGGER.debug("Realm admin account creation exited with code : " + httpResponse.getStatus() + " : " + String.valueOf(httpResponse.getStatusInfo()));
            if (httpResponse.getStatus() == 201) {
                List retrieveCreatedUserList = client.realm(realmId).users().search(user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail(), Integer.valueOf(0), Integer.valueOf(1));
                UserResource retrievedUser = client.realm(realmId).users().get(((UserRepresentation)retrieveCreatedUserList.get(0)).getId());
                RoleResource adminRoleResource = client.realm(realmId).roles().get("admin");
                retrievedUser.roles().realmLevel().add(Collections.singletonList(adminRoleResource.toRepresentation()));
                CredentialRepresentation credential = new CredentialRepresentation();
                credential.setType("password");
                credential.setValue(adminPassword);
                credential.setTemporary(Boolean.valueOf(false));
                retrievedUser.resetPassword(credential);
                List realmClients = client.realm(realmId).clients().findAll();
                String realmManagementClientId = this.getRealmManagementClientId(client, realmId);
                Iterator bl = realmClients.iterator();
                while (true) {
                    if (!bl.hasNext()) {
                        retrievedUser.roles().clientLevel(realmManagementClientId).add(retrievedUser.roles().clientLevel(realmManagementClientId).listAvailable());
                        boolean bl2 = true;
                        return bl2;
                    }
                    ClientRepresentation realmClient = (ClientRepresentation)bl.next();
                    if (!realmClient.getClientId().equals("realm-management")) continue;
                    realmManagementClientId = realmClient.getId();
                }
            }
            LOGGER.error("Request for Tenant Admin Account Creation failed with HTTP code : " + httpResponse.getStatus());
            LOGGER.error("Reason for Tenant Admin account creation failure : " + String.valueOf(httpResponse.getStatusInfo()));
            throw new RuntimeException("Reason for Tenant Admin account creation failure : " + String.valueOf(httpResponse.getStatusInfo()), null);
        }
        catch (Exception ex) {
            String msg = "Error creating Realm Admin Account in keycloak server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateRealmAdminAccount(String realmId, String adminUsername, String adminFirstname, String adminLastname, String adminEmail, String adminPassword) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            UserRepresentation representation = this.getUserByUsername(client, realmId, adminUsername);
            if (representation != null) {
                representation.setUsername(adminUsername);
                representation.setFirstName(adminFirstname);
                representation.setLastName(adminLastname);
                representation.setEmail(adminEmail);
                representation.setEmailVerified(Boolean.valueOf(true));
                representation.setEnabled(Boolean.valueOf(true));
                client.realm(realmId).users().get(representation.getId()).update(representation);
                boolean bl = true;
                return bl;
            }
            boolean throwable = this.createRealmAdminAccount(realmId, adminUsername, adminFirstname, adminLastname, adminEmail, adminPassword);
            return throwable;
        }
        catch (Exception ex) {
            String msg = "Error updating Realm Admin Account in keycloak server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean grantAdminPrivilege(String realmId, String username) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            UserRepresentation representation = this.getUserByUsername(client, realmId, username);
            if (representation != null) {
                UserResource retrievedUser = client.realm(realmId).users().get(representation.getId());
                RoleResource adminRoleResource = client.realm(realmId).roles().get("admin");
                retrievedUser.roles().realmLevel().add(Collections.singletonList(adminRoleResource.toRepresentation()));
                String realmManagementClientId = this.getRealmManagementClientId(client, realmId);
                retrievedUser.roles().clientLevel(realmManagementClientId).add(retrievedUser.roles().clientLevel(realmManagementClientId).listAvailable());
                boolean bl = true;
                return bl;
            }
            LOGGER.error("Cannot find existing user with username: " + username);
            throw new RuntimeException("Cannot find existing user with username: " + username);
        }
        catch (Exception ex) {
            String msg = "Error granting admin privilege, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeAdminPrivilege(String realmId, String username) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            UserRepresentation representation = this.getUserByUsername(client, realmId, username);
            if (representation != null) {
                UserResource retrievedUser = client.realm(realmId).users().get(representation.getId());
                RoleResource adminRoleResource = client.realm(realmId).roles().get("admin");
                retrievedUser.roles().realmLevel().remove(Collections.singletonList(adminRoleResource.toRepresentation()));
                String realmManagementClientId = this.getRealmManagementClientId(client, realmId);
                retrievedUser.roles().clientLevel(realmManagementClientId).remove(retrievedUser.roles().clientLevel(realmManagementClientId).listEffective());
                boolean bl = true;
                return bl;
            }
            LOGGER.error("Cannot find existing user with username: " + username);
            throw new RuntimeException("Cannot find existing user with username: " + username);
        }
        catch (Exception ex) {
            String msg = "Error removing admin privilege, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeycloakClientSecret configureClient(String realmId, String clientName, @NotNull String tenantURL, List<String> redirectUris) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            ClientRepresentation pgaClient = new ClientRepresentation();
            pgaClient.setName(clientName);
            pgaClient.setClientId(clientName);
            pgaClient.setProtocol("openid-connect");
            pgaClient.setStandardFlowEnabled(Boolean.valueOf(true));
            pgaClient.setEnabled(Boolean.valueOf(true));
            pgaClient.setAuthorizationServicesEnabled(Boolean.valueOf(true));
            pgaClient.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
            pgaClient.setServiceAccountsEnabled(Boolean.valueOf(true));
            pgaClient.setFullScopeAllowed(Boolean.valueOf(true));
            pgaClient.setClientAuthenticatorType("client-secret");
            pgaClient.setBaseUrl(tenantURL);
            if (tenantURL.endsWith("/")) {
                tenantURL = tenantURL.substring(0, tenantURL.length() - 1);
            }
            ArrayList<String> newList = new ArrayList<String>(redirectUris);
            newList.add(tenantURL);
            pgaClient.setRedirectUris(newList);
            ArrayList<String> webOrigins = new ArrayList<String>();
            webOrigins.add("+");
            pgaClient.setWebOrigins(webOrigins);
            pgaClient.setPublicClient(Boolean.valueOf(false));
            try (Response httpResponse = client.realms().realm(realmId).clients().create(pgaClient);){
                LOGGER.debug("Realm client configuration exited with code : " + httpResponse.getStatus() + " : " + String.valueOf(httpResponse.getStatusInfo()));
                UserRepresentation serviceAccountUserRepresentation = this.getUserByUsername(client, realmId, "service-account-" + pgaClient.getClientId());
                UserResource serviceAccountUser = client.realms().realm(realmId).users().get(serviceAccountUserRepresentation.getId());
                String realmManagementClientId = this.getRealmManagementClientId(client, realmId);
                List manageUsersRole = serviceAccountUser.roles().clientLevel(realmManagementClientId).listAvailable().stream().filter(r -> r.getName().equals("manage-users")).collect(Collectors.toList());
                serviceAccountUser.roles().clientLevel(realmManagementClientId).add(manageUsersRole);
                if (httpResponse.getStatus() == 201) {
                    String ClientUUID = ((ClientRepresentation)client.realms().realm(realmId).clients().findByClientId(pgaClient.getClientId()).get(0)).getId();
                    CredentialRepresentation clientSecret = client.realms().realm(realmId).clients().get(ClientUUID).getSecret();
                    KeycloakClientSecret keycloakClientSecret = new KeycloakClientSecret(pgaClient.getClientId(), clientSecret.getValue());
                    return keycloakClientSecret;
                }
                LOGGER.error("Request for realm client creation failed with HTTP code : " + httpResponse.getStatus());
                LOGGER.error("Reason for realm client creation failure : " + String.valueOf(httpResponse.getStatusInfo()));
                throw new RuntimeException("Reason for realm client creation failure :" + String.valueOf(httpResponse.getStatusInfo()), null);
            }
        }
        catch (Exception ex) {
            String msg = "Error getting values from property file, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public KeycloakClientSecret updateClient(String realmId, String clientName, @NotNull String tenantURL, List<String> redirectUris) {
        KeycloakClientSecret keycloakClientSecret;
        block10: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                List clientRepresentations = client.realm(realmId).clients().findByClientId(clientName);
                if (clientRepresentations == null || clientRepresentations.isEmpty()) {
                    LOGGER.error("Cannot find a client with name " + clientName);
                    throw new RuntimeException("Cannot find a client with name " + clientName);
                }
                ClientRepresentation pgaClient = (ClientRepresentation)clientRepresentations.get(0);
                pgaClient.setBaseUrl(tenantURL);
                if (tenantURL.endsWith("/")) {
                    tenantURL = tenantURL.substring(0, tenantURL.length() - 1);
                }
                ArrayList<String> newList = new ArrayList<String>(redirectUris);
                newList.add(tenantURL);
                pgaClient.setRedirectUris(newList);
                pgaClient.setPublicClient(Boolean.valueOf(false));
                client.realms().realm(realmId).clients().get(pgaClient.getId()).update(pgaClient);
                String ClientUUID = ((ClientRepresentation)client.realms().realm(realmId).clients().findByClientId(pgaClient.getClientId()).get(0)).getId();
                CredentialRepresentation clientSecret = client.realms().realm(realmId).clients().get(ClientUUID).getSecret();
                keycloakClientSecret = new KeycloakClientSecret(pgaClient.getClientId(), clientSecret.getValue());
                if (client == null) break block10;
            }
            catch (Throwable clientRepresentations) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            clientRepresentations.addSuppressed(throwable);
                        }
                    }
                    throw clientRepresentations;
                }
                catch (Exception ex) {
                    String msg = "Error getting values from property file, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return keycloakClientSecret;
    }

    public boolean isUsernameAvailable(String realmId, String username, String accessToken) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                boolean bl2 = bl = userRepresentation == null;
                if (client == null) break block8;
            }
            catch (Throwable userRepresentation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            userRepresentation.addSuppressed(throwable);
                        }
                    }
                    throw userRepresentation;
                }
                catch (Exception ex) {
                    String msg = "Error getting values from property file, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean createUser(String realmId, String username, String newPassword, String firstName, String lastName, String emailAddress, boolean tempPassowrd, String accessToken) throws UnauthorizedException {
        try (Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);){
            UserRepresentation user = new UserRepresentation();
            user.setUsername(username);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setEmail(emailAddress);
            user.setEnabled(Boolean.valueOf(false));
            Response httpResponse = client.realm(realmId).users().create(user);
            if (httpResponse.getStatus() == 201) {
                List retrieveCreatedUserList = client.realm(realmId).users().search(user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail(), Integer.valueOf(0), Integer.valueOf(1));
                UserResource retrievedUser = client.realm(realmId).users().get(((UserRepresentation)retrieveCreatedUserList.get(0)).getId());
                CredentialRepresentation credential = new CredentialRepresentation();
                credential.setType("password");
                credential.setValue(newPassword);
                credential.setTemporary(Boolean.valueOf(tempPassowrd));
                retrievedUser.resetPassword(credential);
                boolean bl = true;
                return bl;
            }
            String msg = "Reason for user account creation failure : " + String.valueOf(httpResponse.getStatusInfo());
            LOGGER.error("Request for user Account Creation failed with HTTP code : " + httpResponse.getStatus());
            LOGGER.error(msg);
            throw new UnauthorizedException(msg, null);
        }
    }

    public boolean enableUserAccount(String realmId, String accessToken, String username) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                UserResource userResource = client.realm(realmId).users().get(userRepresentation.getId());
                UserRepresentation profile = userResource.toRepresentation();
                profile.setEnabled(Boolean.valueOf(true));
                userResource.update(profile);
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable userRepresentation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            userRepresentation.addSuppressed(throwable);
                        }
                    }
                    throw userRepresentation;
                }
                catch (Exception ex) {
                    String msg = "Error occurred enableUserAccount, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean disableUserAccount(String realmId, String accessToken, String username) {
        boolean bl;
        block9: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                if (userRepresentation != null) {
                    UserResource userResource = client.realm(realmId).users().get(userRepresentation.getId());
                    UserRepresentation profile = userResource.toRepresentation();
                    profile.setEnabled(Boolean.valueOf(false));
                    userResource.update(profile);
                }
                bl = true;
                if (client == null) break block9;
            }
            catch (Throwable userRepresentation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            userRepresentation.addSuppressed(throwable);
                        }
                    }
                    throw userRepresentation;
                }
                catch (Exception ex) {
                    String msg = "Error in disableUserAccount at keycloak, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean isUserAccountEnabled(String realmId, String accessToken, String username) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                boolean bl2 = bl = userRepresentation != null && userRepresentation.isEnabled() != false;
                if (client == null) break block8;
            }
            catch (Throwable userRepresentation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            userRepresentation.addSuppressed(throwable);
                        }
                    }
                    throw userRepresentation;
                }
                catch (Exception ex) {
                    String msg = "Error getting values from property file, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean isUserExist(String realmId, String accessToken, String username) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                boolean bl2 = bl = userRepresentation != null;
                if (client == null) break block8;
            }
            catch (Throwable userRepresentation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            userRepresentation.addSuppressed(throwable);
                        }
                    }
                    throw userRepresentation;
                }
                catch (Exception ex) {
                    String msg = "Error getting values from property file, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public UserRepresentation getUser(String realmId, String accessToken, String username) {
        UserRepresentation userRepresentation;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                userRepresentation = this.getUserByUsername(client, realmId, username);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    String msg = "Error retrieving user, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return userRepresentation;
    }

    public UserRepresentation getUser(String realmId, String username) {
        UserRepresentation userRepresentation;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                userRepresentation = this.getUserByUsername(client, realmId, username);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    String msg = "Error retrieving user, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return userRepresentation;
    }

    public List<UserRepresentation> getUsers(String accessToken, String realmId, int offset, int limit, String username, String firstName, String lastName, String email, String search) {
        List<UserRepresentation> list;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                list = this.searchUsers(client, realmId, username, firstName, lastName, email, search, offset, limit);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while searching for user, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resetUserPassword(String accessToken, String realmId, String username, String newPassword) {
        try (Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);){
            UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
            if (userRepresentation != null) {
                UserResource retrievedUser = client.realm(realmId).users().get(userRepresentation.getId());
                CredentialRepresentation credential = new CredentialRepresentation();
                credential.setType("password");
                credential.setValue(newPassword);
                credential.setTemporary(Boolean.valueOf(false));
                retrievedUser.resetPassword(credential);
                userRepresentation = retrievedUser.toRepresentation();
                userRepresentation.getRequiredActions().remove("UPDATE_PASSWORD");
                retrievedUser.update(userRepresentation);
                boolean bl = true;
                return bl;
            }
            String msg = "requested User not found";
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = "Error resetting user password in keycloak server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public List<UserRepresentation> findUser(String accessToken, String realmId, String email, String userName) {
        List list;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                list = client.realm(realmId).users().search(userName, null, null, email, Integer.valueOf(0), Integer.valueOf(1));
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    String msg = "Error finding user in keycloak server, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return list;
    }

    public void updateUserRepresentation(String accessToken, String realmId, String username, String firstname, String lastName, String email) {
        block9: {
            try (Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);){
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                if (userRepresentation != null) {
                    userRepresentation.setFirstName(firstname);
                    userRepresentation.setLastName(lastName);
                    userRepresentation.setEmail(email);
                    UserResource userResource = client.realm(realmId).users().get(userRepresentation.getId());
                    userResource.update(userRepresentation);
                    break block9;
                }
                throw new RuntimeException("User [" + username + "] wasn't found in Keycloak!");
            }
            catch (Exception ex) {
                String msg = "Error updating user profile in keycloak server, reason: " + ex.getMessage();
                LOGGER.error(msg, (Throwable)ex);
                throw new RuntimeException(msg, ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteUser(String accessToken, String realmId, String username) {
        try (Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);){
            UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
            if (userRepresentation == null) throw new RuntimeException("User [" + username + "] wasn't found in Keycloak!");
            client.realm(realmId).users().delete(userRepresentation.getId());
            boolean throwable = true;
            return throwable;
        }
        catch (Exception ex) {
            String msg = "Error deleting user in keycloak server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public boolean addRolesToUsers(String accessToken, String realmId, List<String> users, List<String> roles, String clientId, boolean clientLevel) {
        boolean bl;
        block12: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                for (String username : users) {
                    RoleResource roleResource;
                    UserRepresentation representation = this.getUserByUsername(client, realmId, username.toLowerCase());
                    ClientRepresentation clientRepresentation = (ClientRepresentation)client.realm(realmId).clients().findByClientId(clientId).get(0);
                    if (representation == null) continue;
                    RealmResource realmResource = client.realm(realmId);
                    UserResource resource = client.realm(realmId).users().get(representation.getId());
                    ArrayList<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
                    if (clientLevel) {
                        for (String role : roles) {
                            roleResource = realmResource.clients().get(clientRepresentation.getId()).roles().get(role);
                            roleRepresentations.add(roleResource.toRepresentation());
                        }
                        resource.roles().clientLevel(clientRepresentation.getId()).add(roleRepresentations);
                        continue;
                    }
                    for (String role : roles) {
                        roleResource = client.realm(realmId).roles().get(role);
                        roleRepresentations.add(roleResource.toRepresentation());
                    }
                    resource.roles().realmLevel().add(roleRepresentations);
                }
                bl = true;
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    String msg = "Error while adding roles to user " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean removeRoleFromUser(String accessToken, String realmId, String username, List<String> roles, String clientId, boolean clientLevel) {
        boolean bl;
        block16: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                UserRepresentation representation = this.getUserByUsername(client, realmId, username.toLowerCase());
                if (representation != null) {
                    UserResource retrievedUser = client.realm(realmId).users().get(representation.getId());
                    if (clientLevel) {
                        List clientRepresentationList = client.realm(realmId).clients().findByClientId(clientId);
                        if (clientRepresentationList != null && !clientRepresentationList.isEmpty()) {
                            ClientRepresentation clientRep = (ClientRepresentation)clientRepresentationList.get(0);
                            ArrayList<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
                            for (String roleName : roles) {
                                RoleResource roleResource = client.realm(realmId).clients().get(clientRep.getId()).roles().get(roleName);
                                if (roleResource == null) continue;
                                roleRepresentations.add(roleResource.toRepresentation());
                            }
                            if (!roleRepresentations.isEmpty()) {
                                retrievedUser.roles().clientLevel(clientRep.getId()).remove(roleRepresentations);
                            }
                        }
                    } else {
                        ArrayList<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
                        for (String roleName : roles) {
                            RoleResource roleResource = client.realm(realmId).roles().get(roleName);
                            if (roleResource == null) continue;
                            roleRepresentations.add(roleResource.toRepresentation());
                        }
                        if (!roleRepresentations.isEmpty()) {
                            retrievedUser.roles().realmLevel().remove(roleRepresentations);
                        }
                    }
                }
                bl = true;
                if (client == null) break block16;
            }
            catch (Throwable representation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            representation.addSuppressed(throwable);
                        }
                    }
                    throw representation;
                }
                catch (Exception ex) {
                    String msg = "Error removing roles from user , reason " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean deleteRealm(String realmId) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            RealmResource realmResource = client.realm(realmId);
            if (realmResource != null) {
                realmResource.remove();
            }
        }
        catch (NotFoundException ex) {
            LOGGER.debug("Realm not found", (Throwable)ex);
        }
        catch (Exception ex) {
            String msg = "Error deleting Realm in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
        return true;
    }

    public boolean configureOIDCFederatedIDP(String realmId, String displayName, String scopes, KeycloakClientSecret secret, Map<String, String> configs) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            RealmResource realmResource = client.realm(realmId);
            List representations = realmResource.identityProviders().findAll();
            for (IdentityProviderRepresentation representation : representations) {
                realmResource.identityProviders().get(representation.getInternalId()).remove();
            }
            IdentityProviderRepresentation idp = new IdentityProviderRepresentation();
            idp.setAlias("oidc");
            idp.setDisplayName(displayName);
            idp.setProviderId("oidc");
            idp.setEnabled(true);
            if (configs != null) {
                idp.setConfig(configs);
            }
            idp.getConfig().put("clientId", secret.getClientId());
            idp.getConfig().put("clientSecret", secret.getClientSecret());
            idp.getConfig().put("authorizationUrl", this.ciLogonAuthorizationEndpoint);
            idp.getConfig().put("tokenUrl", this.ciLogonTokenEndpoint);
            idp.getConfig().put("userInfoUrl", this.ciLogonUserInfoEndpoint);
            idp.getConfig().put("defaultScope", scopes);
            idp.getConfig().put("issuer", this.ciLogonIssuerUri);
            idp.getConfig().put("jwksUri", this.jwksUri);
            idp.getConfig().put("forwardParameters", "idphint");
            realmResource.identityProviders().create(idp);
        }
        catch (Exception ex) {
            String msg = "Error occurred while configuring  IDP in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
        return true;
    }

    public boolean addUserAttributes(String realmId, String accessToken, Map<String, List<String>> attributeMap, List<String> users) {
        try (Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);){
            RealmResource realmResource = client.realm(realmId);
            for (String user : users) {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, user.toLowerCase());
                if (userRepresentation == null) continue;
                UserResource resource = realmResource.users().get(userRepresentation.getId());
                Map exAtrMap = userRepresentation.getAttributes();
                if (exAtrMap != null && !exAtrMap.isEmpty()) {
                    attributeMap.keySet().forEach(key -> exAtrMap.put(key, (List)attributeMap.get(key)));
                    userRepresentation.setAttributes(exAtrMap);
                } else {
                    userRepresentation.setAttributes(attributeMap);
                }
                resource.update(userRepresentation);
            }
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding user attributes in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
        return true;
    }

    public boolean deleteUserAttributes(String realmId, String accessToken, Map<String, List<String>> attributeMap, List<String> users) {
        try (Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);){
            RealmResource realmResource = client.realm(realmId);
            for (String user : users) {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, user.toLowerCase());
                UserResource resource = realmResource.users().get(userRepresentation.getId());
                Map exAtrMap = userRepresentation.getAttributes();
                if (exAtrMap != null && !exAtrMap.isEmpty()) {
                    attributeMap.keySet().forEach(key -> {
                        List stringList = (List)exAtrMap.get(key);
                        if (stringList != null && !stringList.isEmpty()) {
                            stringList.removeAll((Collection)attributeMap.get(key));
                            exAtrMap.put(key, stringList);
                        }
                    });
                    userRepresentation.setAttributes(exAtrMap);
                }
                resource.update(userRepresentation);
            }
        }
        catch (Exception ex) {
            String msg = "Error occurred while deleting user attributes in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
        return true;
    }

    public boolean addProtocolMapper(ProtocolMapperRepresentation protocolMapperRepresentation, String realmId, String clientId) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            RealmResource realmResource = client.realm(realmId);
            ClientRepresentation representation = (ClientRepresentation)realmResource.clients().findByClientId(clientId).get(0);
            ProtocolMappersResource resource = realmResource.clients().get(representation.getId()).getProtocolMappers();
            resource.createMapper(protocolMapperRepresentation);
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding protocol mappers in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
        return true;
    }

    public List<UserRepresentation> getAllUsers(String realmId) {
        ArrayList<UserRepresentation> arrayList;
        block10: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                List representations = client.realm(realmId).users().list();
                ArrayList<UserRepresentation> representationList = new ArrayList<UserRepresentation>();
                if (representations != null && !representations.isEmpty()) {
                    for (UserRepresentation userRepresentation : representations) {
                        UserRepresentation userRep = this.getUserByUsername(client, realmId, userRepresentation.getUsername());
                        representationList.add(userRep);
                    }
                }
                arrayList = representationList;
                if (client == null) break block10;
            }
            catch (Throwable representations) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            representations.addSuppressed(throwable);
                        }
                    }
                    throw representations;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while adding protocol mappers in Keycloak Server, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return arrayList;
    }

    public boolean addRoles(List<RoleRepresentation> roleRepresentations, String realmId, String clientId, boolean clientScope) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            RealmResource realmResource = client.realm(realmId);
            if (clientScope) {
                ClientRepresentation representation = (ClientRepresentation)realmResource.clients().findByClientId(clientId).get(0);
                for (RoleRepresentation roleRepresentation : roleRepresentations) {
                    realmResource.clients().get(representation.getId()).roles().create(roleRepresentation);
                }
            } else {
                for (RoleRepresentation representation : roleRepresentations) {
                    realmResource.roles().create(representation);
                }
            }
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding roles in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
        return true;
    }

    public boolean deleteRole(String id, String realmId, String clientId, boolean clientScope) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            RealmResource realmResource = client.realm(realmId);
            if (clientScope) {
                ClientRepresentation representation = (ClientRepresentation)realmResource.clients().findByClientId(clientId).get(0);
                realmResource.clients().get(representation.getId()).roles().deleteRole(id);
            } else {
                realmResource.roles().deleteRole(id);
            }
        }
        catch (Exception ex) {
            String msg = "Error occurred while delete role" + id + " in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RoleRepresentation> getAllRoles(String realmId, String clientId) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            RealmResource realmResource222 = client.realm(realmId);
            if (clientId != null) {
                ClientRepresentation representation = (ClientRepresentation)realmResource222.clients().findByClientId(clientId).get(0);
                List list = realmResource222.clients().get(representation.getId()).roles().list();
                return list;
            }
            List throwable = realmResource222.roles().list();
            return throwable;
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding roles in Keycloak Server, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public boolean configureEventPersistence(String realmId, String eventType, long time, boolean enableEvents, boolean isAdminEvent) {
        boolean bl;
        block12: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                RealmEventsConfigRepresentation representation = client.realm(realmId).getRealmEventsConfig();
                if (isAdminEvent) {
                    representation.setAdminEventsEnabled(Boolean.valueOf(true));
                } else {
                    representation.setEventsEnabled(enableEvents);
                    representation.setEventsExpiration(Long.valueOf(time));
                    ArrayList<String> eventTypes = representation.getEnabledEventTypes();
                    if (eventTypes != null && !eventTypes.isEmpty() && !eventTypes.contains(eventType)) {
                        eventTypes.add(eventType);
                    } else {
                        eventTypes = new ArrayList<String>();
                        eventTypes.add(eventType);
                    }
                    representation.setEnabledEventTypes(eventTypes);
                    client.realm(realmId).updateRealmEventsConfig(representation);
                }
                bl = true;
                if (client == null) break block12;
            }
            catch (Throwable representation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            representation.addSuppressed(throwable);
                        }
                    }
                    throw representation;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while configuring event persistence events, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public EventRepresentation getLastLoginEvent(String realmId, String clientId, String username) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            List eventRepresentations = client.realm(realmId).getEvents();
            for (EventRepresentation representation : eventRepresentations) {
                Map map = representation.getDetails();
                if (map == null || map.isEmpty()) continue;
                for (String key : map.keySet()) {
                    if (!key.equals("username") || !((String)map.get(key)).equals(username)) continue;
                    EventRepresentation eventRepresentation = representation;
                    return eventRepresentation;
                }
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception ex) {
            String msg = "Error occurred while pulling events, reason: " + ex.getMessage();
            LOGGER.warn(msg, (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserSessionRepresentation getLatestSession(String realmId, String clientId, String accessToken, String username) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            List userResourceList = client.realm(realmId).users().search(username.toLowerCase(), null, null, null, null, null);
            if (!userResourceList.isEmpty() && ((UserRepresentation)userResourceList.get(0)).getUsername().equals(username.toLowerCase())) {
                UserRepresentation userRepresentation = (UserRepresentation)userResourceList.get(0);
                List userSessionRepresentations = client.realm(realmId).users().get(userRepresentation.getId()).getUserSessions();
                if (!userSessionRepresentations.isEmpty()) {
                    UserSessionRepresentation userSessionRepresentation = (UserSessionRepresentation)userSessionRepresentations.get(userSessionRepresentations.size() - 1);
                    return userSessionRepresentation;
                }
            }
            UserSessionRepresentation throwable = null;
            return throwable;
        }
        catch (Exception ex) {
            String msg = "Error occurred while pulling active user sessions, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public boolean deleteExternalIDPLinks(String realmId) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                RealmResource realmResource = client.realm(realmId);
                List userResourceList = client.realm(realmId).users().list();
                userResourceList.forEach(user -> {
                    UserResource userResource = realmResource.users().get(user.getId());
                    List federatedIdentityRepresentations = userResource.getFederatedIdentity();
                    if (federatedIdentityRepresentations != null && !federatedIdentityRepresentations.isEmpty()) {
                        federatedIdentityRepresentations.forEach(fed -> userResource.removeFederatedIdentity(fed.getIdentityProvider()));
                    }
                });
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable realmResource) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            realmResource.addSuppressed(throwable);
                        }
                    }
                    throw realmResource;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while deleting external IDP links of realm " + realmId + ", reason " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean deleteExternalIDPLinks(String realmId, List<String> users) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                RealmResource realmResource = client.realm(realmId);
                List userResourceList = client.realm(realmId).users().list();
                userResourceList.forEach(user -> {
                    UserResource userResource;
                    List federatedIdentityRepresentations;
                    if (users.contains(user.getUsername()) && (federatedIdentityRepresentations = (userResource = realmResource.users().get(user.getId())).getFederatedIdentity()) != null && !federatedIdentityRepresentations.isEmpty()) {
                        federatedIdentityRepresentations.forEach(fed -> userResource.removeFederatedIdentity(fed.getIdentityProvider()));
                    }
                });
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable realmResource) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            realmResource.addSuppressed(throwable);
                        }
                    }
                    throw realmResource;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while deleting external IDP links of realm " + realmId + ", reason " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public List<FederatedIdentityRepresentation> getExternalIDPLinks(String realmId, String requestedUser) {
        ArrayList<FederatedIdentityRepresentation> arrayList;
        block8: {
            ArrayList<FederatedIdentityRepresentation> arrayList2 = new ArrayList<FederatedIdentityRepresentation>();
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                RealmResource realmResource = client.realm(realmId);
                List userResourceList = client.realm(realmId).users().list();
                userResourceList.forEach(user -> {
                    UserResource userResource;
                    List federatedIdentityRepresentations;
                    if (requestedUser.equals(user.getUsername()) && (federatedIdentityRepresentations = (userResource = realmResource.users().get(user.getId())).getFederatedIdentity()) != null && !federatedIdentityRepresentations.isEmpty()) {
                        arrayList2.addAll(federatedIdentityRepresentations);
                    }
                });
                arrayList = arrayList2;
                if (client == null) break block8;
            }
            catch (Throwable realmResource) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            realmResource.addSuppressed(throwable);
                        }
                    }
                    throw realmResource;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while deleting external IDP links of realm " + realmId + ", reason " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return arrayList;
    }

    public void addExternalIDPLinks(String realmId, List<FederatedIdentityRepresentation> representations) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            if (representations != null && !representations.isEmpty()) {
                representations.forEach(fed -> {
                    List userRepresentationList = client.realm(realmId).users().search(fed.getUserName());
                    userRepresentationList.forEach(user -> {
                        UserResource userResource = client.realm(realmId).users().get(user.getId());
                        userResource.addFederatedIdentity(fed.getIdentityProvider(), fed);
                    });
                });
            }
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding external IDP links " + realmId + ", reason " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GroupRepresentation> createGroups(String realmId, String clientId, String clientSec, List<GroupRepresentation> groupRepresentations) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            ArrayList<GroupRepresentation> representationList = new ArrayList<GroupRepresentation>();
            Iterator<GroupRepresentation> iterator = groupRepresentations.iterator();
            if (!iterator.hasNext()) return null;
            GroupRepresentation representation = iterator.next();
            Response response = client.realm(realmId).groups().add(representation);
            if (response.getStatus() == 201) {
                String id = this.getCreatedId(response);
                if (representation.getRealmRoles() != null && !representation.getRealmRoles().isEmpty()) {
                    ArrayList<RoleRepresentation> roleRepresentation = new ArrayList<RoleRepresentation>();
                    for (String role : representation.getRealmRoles()) {
                        RoleResource resource = client.realm(realmId).roles().get(role);
                        if (resource == null) continue;
                        roleRepresentation.add(resource.toRepresentation());
                    }
                    if (!roleRepresentation.isEmpty()) {
                        client.realm(realmId).groups().group(id).roles().realmLevel().add(roleRepresentation);
                    }
                }
                if (representation.getClientRoles() != null && !representation.getClientRoles().isEmpty()) {
                    ArrayList<RoleRepresentation> clientRepresentations = new ArrayList<RoleRepresentation>();
                    ClientRepresentation clientRepresentation = (ClientRepresentation)client.realm(realmId).clients().findByClientId(clientId).get(0);
                    for (String role : (List)representation.getClientRoles().get(clientId)) {
                        RoleResource resource = client.realm(realmId).clients().get(clientRepresentation.getId()).roles().get(role);
                        if (resource == null) continue;
                        clientRepresentations.add(resource.toRepresentation());
                    }
                    if (!clientRepresentations.isEmpty()) {
                        client.realm(realmId).groups().group(id).roles().clientLevel(clientRepresentation.getId()).add(clientRepresentations);
                    }
                }
                representation.setId(id);
                this.createGroup(client, realmId, clientId, representation);
                response.close();
                GroupRepresentation savedRep = client.realm(realmId).groups().group(representation.getId()).toRepresentation();
                representationList.add(savedRep);
                ArrayList<GroupRepresentation> arrayList = representationList;
                return arrayList;
            }
            if (response.getStatus() == 401) {
                String msg = "Error occurred while creating group, reason: HTTP " + response.getStatus() + " Unauthorized";
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            String msg = "Error occurred while creating group, reason: HTTP  " + response.getStatus();
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred while creating group, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public GroupRepresentation updateGroup(String realmId, String clientId, String clientSec, GroupRepresentation groupRepresentation) {
        GroupRepresentation groupRepresentation2;
        block16: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                client.realm(realmId).groups().group(groupRepresentation.getId()).update(groupRepresentation);
                List exRoles = client.realm(realmId).groups().group(groupRepresentation.getId()).roles().realmLevel().listAll();
                if (exRoles != null && !exRoles.isEmpty()) {
                    client.realm(realmId).groups().group(groupRepresentation.getId()).roles().realmLevel().remove(exRoles);
                }
                if (groupRepresentation.getRealmRoles() != null && !groupRepresentation.getRealmRoles().isEmpty()) {
                    ArrayList<RoleRepresentation> roleRepresentation = new ArrayList<RoleRepresentation>();
                    for (String role : groupRepresentation.getRealmRoles()) {
                        RoleResource resource = client.realm(realmId).roles().get(role);
                        if (resource == null) continue;
                        roleRepresentation.add(resource.toRepresentation());
                    }
                    if (!roleRepresentation.isEmpty()) {
                        client.realm(realmId).groups().group(groupRepresentation.getId()).roles().realmLevel().add(roleRepresentation);
                    }
                }
                ClientRepresentation clientRepresentation = (ClientRepresentation)client.realm(realmId).clients().findByClientId(clientId).get(0);
                List exClientRoles = client.realm(realmId).groups().group(groupRepresentation.getId()).roles().clientLevel(clientRepresentation.getId()).listAll();
                if (exClientRoles != null && !exClientRoles.isEmpty()) {
                    client.realm(realmId).groups().group(groupRepresentation.getId()).roles().clientLevel(clientRepresentation.getId()).remove(exClientRoles);
                }
                if (groupRepresentation.getClientRoles() != null && !groupRepresentation.getClientRoles().isEmpty()) {
                    ArrayList<RoleRepresentation> clientRepresentations = new ArrayList<RoleRepresentation>();
                    for (String role : (List)groupRepresentation.getClientRoles().get(clientId)) {
                        RoleResource resource = client.realm(realmId).clients().get(clientRepresentation.getId()).roles().get(role);
                        if (resource == null) continue;
                        clientRepresentations.add(resource.toRepresentation());
                    }
                    if (!clientRepresentations.isEmpty()) {
                        client.realm(realmId).groups().group(groupRepresentation.getId()).roles().clientLevel(clientRepresentation.getId()).add(clientRepresentations);
                    }
                }
                groupRepresentation2 = client.realm(realmId).groups().group(groupRepresentation.getId()).toRepresentation();
                if (client == null) break block16;
            }
            catch (Throwable exRoles) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            exRoles.addSuppressed(throwable);
                        }
                    }
                    throw exRoles;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while updating group, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return groupRepresentation2;
    }

    public boolean deleteGroup(String realmId, String clientId, String clientSec, String groupId) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                String id = client.realm(realmId).groups().group(groupId).toRepresentation().getId();
                client.realm(realmId).groups().group(id).remove();
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable id) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            id.addSuppressed(throwable);
                        }
                    }
                    throw id;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while deleting group, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupRepresentation findGroup(String realmId, String accessToken, String id, String name) {
        try (Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);){
            if (id != null && !id.trim().isEmpty()) {
                GroupResource resource = client.realm(realmId).groups().group(id);
                if (resource == null) return null;
                GroupRepresentation groupRepresentation = resource.toRepresentation();
                return groupRepresentation;
            }
            List groupRepresentations = client.realm(realmId).groups().groups(name, Integer.valueOf(0), Integer.valueOf(1));
            if (groupRepresentations == null) return null;
            if (groupRepresentations.isEmpty()) return null;
            GroupRepresentation groupRepresentation = (GroupRepresentation)groupRepresentations.get(0);
            return groupRepresentation;
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("HTTP 404")) {
                return null;
            }
            String msg = "Error occurred finding groups, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public List<GroupRepresentation> getAllGroups(String realmId, String accessToken) {
        ArrayList<GroupRepresentation> arrayList;
        block10: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                ArrayList<GroupRepresentation> groupRepresentations = new ArrayList<GroupRepresentation>();
                for (GroupRepresentation representation : client.realm(realmId).groups().groups()) {
                    groupRepresentations.add(client.realm(realmId).groups().group(representation.getId()).toRepresentation());
                }
                arrayList = groupRepresentations;
                if (client == null) break block10;
            }
            catch (Throwable groupRepresentations) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            groupRepresentations.addSuppressed(throwable);
                        }
                    }
                    throw groupRepresentations;
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("HTTP 404")) {
                        return null;
                    }
                    String msg = "Error occurred finding groups, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return arrayList;
    }

    public boolean addUserToGroup(String realmId, String username, String groupId, String accessToken) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                client.realm(realmId).users().get(userRepresentation.getId()).joinGroup(groupId);
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable userRepresentation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            userRepresentation.addSuppressed(throwable);
                        }
                    }
                    throw userRepresentation;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while adding user to group, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean removeUserFromGroup(String realmId, String username, String groupId, String accessToken) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                UserRepresentation userRepresentation = this.getUserByUsername(client, realmId, username);
                client.realm(realmId).users().get(userRepresentation.getId()).leaveGroup(groupId);
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable userRepresentation) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            userRepresentation.addSuppressed(throwable);
                        }
                    }
                    throw userRepresentation;
                }
                catch (Exception ex) {
                    String msg = "Error occurred while remove user from group, reason: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configureAgentClient(String realmId, String clientId, long accessTokenLifeTime) {
        try (Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);){
            ClientRepresentation representation = (ClientRepresentation)client.realm(realmId).clients().findByClientId(clientId).get(0);
            if (representation != null) {
                HashMap<String, String> attributes = representation.getAttributes();
                if (attributes == null || attributes.isEmpty()) {
                    attributes = new HashMap<String, String>();
                }
                attributes.put("access.token.lifespan", String.valueOf(accessTokenLifeTime));
                client.realm(realmId).clients().get(representation.getId()).update(representation);
                boolean bl = true;
                return bl;
            }
            boolean throwable = false;
            return throwable;
        }
        catch (Exception ex) {
            String msg = "Error occurred while remove user from group, reason: " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public boolean isValidEndUser(String realmId, String username, String accessToken) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, realmId, accessToken);
            try {
                bl = this.isValidEndUser(client, realmId, username);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    String msg = "Error occurred end user validity: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean isValidEndUser(String realmId, String username) {
        boolean bl;
        block8: {
            Keycloak client = this.getClient(this.iamServerURL, this.superAdminRealmID, this.superAdminUserName, this.superAdminPassword);
            try {
                bl = this.isValidEndUser(client, realmId, username);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    String msg = "Error occurred end user validity: " + ex.getMessage();
                    LOGGER.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            client.close();
        }
        return bl;
    }

    public Map<String, Object> getUserInfo(String accessToken, long realmId) {
        String userInfoEndpoint = this.iamServerURL + "realms/" + realmId + "/protocol/openid-connect/userinfo";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(userInfoEndpoint)).header("Authorization", "Bearer " + accessToken).header("Accept", "application/json").GET().build();
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return (Map)this.objectMapper.readValue(response.body(), Map.class);
            }
            throw new IllegalStateException("Failed to fetch user info: Status code " + response.statusCode());
        }
        catch (Exception e) {
            throw new RuntimeException("Error fetching user info", e);
        }
    }

    private boolean isValidEndUser(Keycloak client, String realmId, String username) {
        UserRepresentation representation = this.getUserByUsername(client, realmId, username);
        if (representation == null) {
            return false;
        }
        Map attributes = representation.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            for (String key : attributes.keySet()) {
                if (!key.equals("custos-realm-agent")) continue;
                return false;
            }
        }
        return true;
    }

    private Keycloak getClient(String adminUrl, String realm, String loginUsername, String password) {
        return KeycloakUtils.getClient(adminUrl, realm, loginUsername, password, this.clientId);
    }

    private Keycloak getClient(String adminUrl, String realm, String accessToken) {
        return KeycloakUtils.getClient(adminUrl, realm, accessToken);
    }

    private RealmRepresentation createDefaultRoles(RealmRepresentation realmDetails) {
        ArrayList<RoleRepresentation> defaultRoles = new ArrayList<RoleRepresentation>();
        RoleRepresentation adminRole = new RoleRepresentation();
        adminRole.setName("admin");
        adminRole.setDescription("Admin role for PGA users");
        defaultRoles.add(adminRole);
        RolesRepresentation rolesRepresentation = new RolesRepresentation();
        rolesRepresentation.setRealm(defaultRoles);
        realmDetails.setRoles(rolesRepresentation);
        return realmDetails;
    }

    private String getRealmManagementClientId(Keycloak client, String realmId) {
        List realmClients = client.realm(realmId).clients().findAll();
        String realmManagementClientId = null;
        for (ClientRepresentation realmClient : realmClients) {
            if (!realmClient.getClientId().equals("realm-management")) continue;
            realmManagementClientId = realmClient.getId();
        }
        return realmManagementClientId;
    }

    private Optional<String> getRealmManagementClientSecret(Keycloak client, String realmId) {
        List realmClients = client.realm(realmId).clients().findAll();
        String realmManagementClientId = null;
        for (ClientRepresentation realmClient : realmClients) {
            if (!realmClient.getClientId().equals("realm-management")) continue;
            realmManagementClientId = realmClient.getClientId();
            String ClientUUID = ((ClientRepresentation)client.realms().realm(realmId).clients().findByClientId(realmManagementClientId).get(0)).getId();
            return Optional.ofNullable(client.realms().realm(realmId).clients().get(ClientUUID).getSecret().getValue());
        }
        return Optional.empty();
    }

    private UserRepresentation getUserByUsername(Keycloak client, String tenantId, String username) {
        List userResourceList = client.realm(tenantId).users().search(username.toLowerCase(), null, null, null, null, null);
        for (UserRepresentation userRepresentation : userResourceList) {
            Cloneable roleRepresentations;
            if (!userRepresentation.getUsername().equals(username.toLowerCase())) continue;
            RoleMappingResource resource = client.realm(tenantId).users().get(userRepresentation.getId()).roles();
            MappingsRepresentation representation = resource.getAll();
            if (representation != null && representation.getRealmMappings() != null) {
                roleRepresentations = new ArrayList();
                representation.getRealmMappings().forEach(t -> roleRepresentations.add(t.getName()));
                userRepresentation.setRealmRoles(roleRepresentations);
            }
            if (representation != null && representation.getClientMappings() != null) {
                roleRepresentations = new HashMap();
                representation.getClientMappings().keySet().forEach(key -> {
                    if (((ClientMappingsRepresentation)representation.getClientMappings().get(key)).getMappings() != null) {
                        ArrayList roleList = new ArrayList();
                        ((ClientMappingsRepresentation)representation.getClientMappings().get(key)).getMappings().forEach(t -> roleList.add(t.getName()));
                        roleRepresentations.put(key, roleList);
                    }
                });
                userRepresentation.setClientRoles(roleRepresentations);
            }
            return userRepresentation;
        }
        return null;
    }

    private boolean createGroup(Keycloak client, String realmId, String clientId, GroupRepresentation parentRepresentation) {
        List groupRepresentations;
        if (parentRepresentation.getSubGroups() != null && !parentRepresentation.getSubGroups().isEmpty() && (groupRepresentations = parentRepresentation.getSubGroups()) != null && !groupRepresentations.isEmpty()) {
            for (GroupRepresentation representation : groupRepresentations) {
                Response createdRes = client.realm(realmId).groups().add(representation);
                String id = this.getCreatedId(createdRes);
                if (id == null) continue;
                representation.setId(id);
                Response response = client.realm(realmId).groups().group(parentRepresentation.getId()).subGroup(representation);
                if (response.getStatus() == 201 || response.getStatus() == 204) {
                    if (representation.getRealmRoles() != null && !representation.getRealmRoles().isEmpty()) {
                        ArrayList<RoleRepresentation> roleRepresentation = new ArrayList<RoleRepresentation>();
                        for (String role : representation.getRealmRoles()) {
                            RoleResource resource = client.realm(realmId).roles().get(role);
                            if (resource == null) continue;
                            roleRepresentation.add(resource.toRepresentation());
                        }
                        if (!roleRepresentation.isEmpty()) {
                            client.realm(realmId).groups().group(id).roles().realmLevel().add(roleRepresentation);
                        }
                    }
                    if (representation.getClientRoles() != null && !representation.getClientRoles().isEmpty()) {
                        ArrayList<RoleRepresentation> clientRepresentations = new ArrayList<RoleRepresentation>();
                        ClientRepresentation clientRepresentation = (ClientRepresentation)client.realm(realmId).clients().findByClientId(clientId).get(0);
                        for (String role : (List)representation.getClientRoles().get(clientId)) {
                            RoleResource resource = client.realm(realmId).clients().get(clientRepresentation.getId()).roles().get(role);
                            if (resource == null) continue;
                            clientRepresentations.add(resource.toRepresentation());
                        }
                        if (!clientRepresentations.isEmpty()) {
                            client.realm(realmId).groups().group(id).roles().clientLevel(clientRepresentation.getId()).add(clientRepresentations);
                        }
                    }
                    this.createGroup(client, realmId, clientId, representation);
                }
                response.close();
            }
        }
        return true;
    }

    private List<UserRepresentation> searchUsers(Keycloak client, String tenantId, String username, String firstName, String lastName, String email, String search, int offset, int limit) {
        List userResourceList = null;
        userResourceList = search != null && !search.trim().equals("") ? client.realm(tenantId).users().search(search, Integer.valueOf(offset), Integer.valueOf(limit)) : client.realm(tenantId).users().search(username.toLowerCase(), firstName, lastName, email, Integer.valueOf(offset), Integer.valueOf(limit));
        if (userResourceList != null && !userResourceList.isEmpty()) {
            ArrayList<UserRepresentation> newList = new ArrayList<UserRepresentation>();
            for (UserRepresentation userRepresentation : userResourceList) {
                Cloneable roleRepresentations;
                RoleMappingResource resource = client.realm(tenantId).users().get(userRepresentation.getId()).roles();
                MappingsRepresentation representation = resource.getAll();
                if (representation != null && representation.getRealmMappings() != null) {
                    roleRepresentations = new ArrayList();
                    representation.getRealmMappings().forEach(t -> roleRepresentations.add(t.getName()));
                    userRepresentation.setRealmRoles(roleRepresentations);
                }
                if (representation != null && representation.getClientMappings() != null) {
                    roleRepresentations = new HashMap();
                    representation.getClientMappings().keySet().forEach(key -> {
                        if (((ClientMappingsRepresentation)representation.getClientMappings().get(key)).getMappings() != null) {
                            ArrayList roleList = new ArrayList();
                            ((ClientMappingsRepresentation)representation.getClientMappings().get(key)).getMappings().forEach(t -> roleList.add(t.getName()));
                            roleRepresentations.put(key, roleList);
                        }
                    });
                    userRepresentation.setClientRoles(roleRepresentations);
                }
                newList.add(userRepresentation);
            }
            return userResourceList;
        }
        return userResourceList;
    }

    private String getCreatedId(Response response) {
        URI location = response.getLocation();
        if (location == null) {
            return null;
        }
        String path = location.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

