/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CoreServiceCreationConfigurationParser;
import org.ehcache.xml.XmlUtil;
import org.ehcache.xml.model.ConfigType;
import org.ehcache.xml.model.ServiceType;
import org.ehcache.xml.provider.CacheEventDispatcherFactoryConfigurationParser;
import org.ehcache.xml.provider.CacheManagerPersistenceConfigurationParser;
import org.ehcache.xml.provider.DefaultCopyProviderConfigurationParser;
import org.ehcache.xml.provider.DefaultSerializationProviderConfigurationParser;
import org.ehcache.xml.provider.DefaultSizeOfEngineProviderConfigurationParser;
import org.ehcache.xml.provider.OffHeapDiskStoreProviderConfigurationParser;
import org.ehcache.xml.provider.PooledExecutionServiceConfigurationParser;
import org.ehcache.xml.provider.WriteBehindProviderConfigurationParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceCreationConfigurationParser {
    static final Collection<CoreServiceCreationConfigurationParser<ConfigType>> CORE_SERVICE_CREATION_CONFIGURATION_PARSERS = Arrays.asList(new DefaultCopyProviderConfigurationParser(), new DefaultSerializationProviderConfigurationParser(), new OffHeapDiskStoreProviderConfigurationParser(), new CacheEventDispatcherFactoryConfigurationParser(), new DefaultSizeOfEngineProviderConfigurationParser(), new CacheManagerPersistenceConfigurationParser(), new PooledExecutionServiceConfigurationParser(), new WriteBehindProviderConfigurationParser());
    private final Map<Class<?>, CacheManagerServiceConfigurationParser<?, ?>> extensionParsers;

    public ServiceCreationConfigurationParser(Map<Class<?>, CacheManagerServiceConfigurationParser<?, ?>> extensionParsers) {
        this.extensionParsers = extensionParsers;
    }

    FluentConfigurationBuilder<?> parse(Document document, ConfigType configRoot, ClassLoader classLoader, FluentConfigurationBuilder<?> managerBuilder) throws ClassNotFoundException {
        for (CoreServiceCreationConfigurationParser<ConfigType> parser2 : CORE_SERVICE_CREATION_CONFIGURATION_PARSERS) {
            managerBuilder = parser2.parseServiceCreationConfiguration(configRoot, classLoader, managerBuilder);
        }
        Map<URI, CacheManagerServiceConfigurationParser> parsers = this.extensionParsers.values().stream().flatMap(parser -> parser.getTargetNamespaces().stream().map(ns -> new AbstractMap.SimpleImmutableEntry<URI, CacheManagerServiceConfigurationParser>((URI)ns, (CacheManagerServiceConfigurationParser)parser))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (ServiceType serviceType : configRoot.getService()) {
            Element element = (Element)XmlUtil.findMatchingNodeInDocument(document, serviceType.getServiceCreationConfiguration()).cloneNode(true);
            URI namespace = URI.create(element.getNamespaceURI());
            CacheManagerServiceConfigurationParser cacheManagerServiceConfigurationParser = parsers.get(namespace);
            if (cacheManagerServiceConfigurationParser == null) {
                throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
            }
            ServiceCreationConfiguration serviceConfiguration = (ServiceCreationConfiguration)cacheManagerServiceConfigurationParser.parse(element, classLoader);
            managerBuilder = managerBuilder.withService(serviceConfiguration);
        }
        return managerBuilder;
    }

    ConfigType unparse(Document target, Configuration configuration, ConfigType configType) {
        for (CoreServiceCreationConfigurationParser<ConfigType> parser : CORE_SERVICE_CREATION_CONFIGURATION_PARSERS) {
            parser.unparseServiceCreationConfiguration(configuration, configType);
        }
        List<ServiceType> services = configType.getService();
        configuration.getServiceCreationConfigurations().forEach(config -> {
            CacheManagerServiceConfigurationParser<?, ?> parser = this.extensionParsers.get(config.getServiceType());
            if (parser != null) {
                ServiceType serviceType = new ServiceType();
                Element element = parser.unparse(target, config);
                serviceType.setServiceCreationConfiguration(element);
                services.add(serviceType);
            }
        });
        return configType;
    }
}

