/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.authentication;

import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.apache.cxf.fediz.spring.SpringFedizMessageSource;
import org.apache.cxf.fediz.spring.authentication.FederationAuthenticationToken;
import org.apache.cxf.fediz.spring.authentication.FederationResponseAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.util.Assert;

public class FederationAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
MessageSourceAware {
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticationProvider.class);
    protected MessageSourceAccessor messages = SpringFedizMessageSource.getAccessor();
    private AuthenticationUserDetailsService<FederationResponseAuthenticationToken> authenticationUserDetailsService;
    private FederationConfig federationConfig;
    private final UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();

    public AuthenticationUserDetailsService<FederationResponseAuthenticationToken> getAuthenticationUserDetailsService() {
        return this.authenticationUserDetailsService;
    }

    public void setAuthenticationUserDetailsService(AuthenticationUserDetailsService<FederationResponseAuthenticationToken> authenticationUserDetailsService) {
        this.authenticationUserDetailsService = authenticationUserDetailsService;
    }

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.authenticationUserDetailsService, (String)"An authenticationUserDetailsService must be set");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        Assert.notNull((Object)this.federationConfig, (String)"FederationConfig cannot be null.");
    }

    public Authentication authenticate(Authentication authentication) {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (!(authentication instanceof UsernamePasswordAuthenticationToken)) {
            return null;
        }
        if (authentication.getCredentials() == null || "".equals(authentication.getCredentials())) {
            throw new BadCredentialsException(this.messages.getMessage("FederationAuthenticationProvider.noSignInRequest", "Failed to get SignIn request"));
        }
        FederationAuthenticationToken result = this.authenticateNow(authentication);
        result.setDetails(authentication.getDetails());
        return result;
    }

    private FederationAuthenticationToken authenticateNow(Authentication authentication) {
        try {
            FedizRequest wfReq = (FedizRequest)authentication.getCredentials();
            FedizContext fedContext = this.federationConfig.getFedizContext();
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedContext.getProtocol());
            FedizResponse wfRes = wfProc.processRequest(wfReq, fedContext);
            UserDetails userDetails = this.loadUserByFederationResponse(wfRes);
            this.userDetailsChecker.check(userDetails);
            return new FederationAuthenticationToken(userDetails, authentication.getCredentials(), this.authoritiesMapper.mapAuthorities(userDetails.getAuthorities()), userDetails, wfRes);
        }
        catch (Exception e) {
            LOG.error("Failed to validate SignIn request", (Throwable)e);
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    protected UserDetails loadUserByFederationResponse(FedizResponse response) {
        FederationResponseAuthenticationToken token = new FederationResponseAuthenticationToken(response);
        return this.authenticationUserDetailsService.loadUserDetails((Authentication)token);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication) || FederationAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

