/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.objects;

import com.google.inject.Injector;
import java.util.concurrent.locks.ReentrantLock;
import org.testng.ITestContext;
import org.testng.annotations.Guice;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.invokers.objects.GuiceContext;
import org.testng.internal.objects.GuiceHelper;
import org.testng.internal.objects.IObjectDispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;

class GuiceBasedObjectDispenser
implements IObjectDispenser {
    private IObjectDispenser dispenser;
    private static final ReentrantLock lock = new ReentrantLock();

    GuiceBasedObjectDispenser() {
    }

    @Override
    public void setNextDispenser(IObjectDispenser dispenser) {
        this.dispenser = dispenser;
    }

    @Override
    public Object dispense(CreationAttributes attributes) {
        if (attributes.getBasicAttributes() == null) {
            return this.dispenser.dispense(attributes);
        }
        try {
            lock.lock();
            Object object = this.dispenseObject(attributes);
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    private Object dispenseObject(CreationAttributes attributes) {
        GuiceHelper helper;
        Class<?> cls;
        BasicAttributes sa = attributes.getBasicAttributes();
        Class<?> clazz = cls = sa.getTestClass() == null ? sa.getRawClass() : sa.getTestClass().getRealClass();
        if (GuiceBasedObjectDispenser.cannotDispense(cls)) {
            return this.dispenser.dispense(attributes);
        }
        ITestContext ctx = attributes.getContext();
        GuiceContext suiteCtx = attributes.getSuiteContext();
        if (ctx == null) {
            helper = new GuiceHelper(suiteCtx);
        } else {
            helper = (GuiceHelper)ctx.getAttribute("testng.guice-helper");
            if (helper == null) {
                helper = new GuiceHelper(ctx);
                ctx.setAttribute("testng.guice-helper", helper);
            }
        }
        Injector injector = ctx == null ? helper.getInjector(cls, suiteCtx.getInjectorFactory()) : helper.getInjector(cls, ctx.getInjectorFactory());
        if (injector == null) {
            return null;
        }
        if (sa.getRawClass() == null) {
            return injector.getInstance(sa.getTestClass().getRealClass());
        }
        return injector.getInstance(sa.getRawClass());
    }

    private static boolean cannotDispense(Class<?> clazz) {
        return AnnotationHelper.findAnnotationSuperClasses(Guice.class, clazz) == null;
    }
}

