/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ProtocolVersion;

public class Stats {
    private final AtomicInteger successCount = new AtomicInteger();
    private final AtomicInteger failureCount = new AtomicInteger();
    private final AtomicInteger keepAliveCount = new AtomicInteger();
    private final AtomicLong totalBytesRecv = new AtomicLong();
    private final AtomicLong totalBytesSent = new AtomicLong();
    private final AtomicLong contentLength = new AtomicLong();
    private final AtomicLong totalContentLength = new AtomicLong();
    private final AtomicReference<String> serverNameRef = new AtomicReference();
    private final AtomicReference<ProtocolVersion> versionRef = new AtomicReference();

    public void incSuccessCount() {
        this.successCount.incrementAndGet();
    }

    public int getSuccessCount() {
        return this.successCount.get();
    }

    public void incFailureCount() {
        this.failureCount.incrementAndGet();
    }

    public int getFailureCount() {
        return this.failureCount.get();
    }

    public void incKeepAliveCount() {
        this.keepAliveCount.incrementAndGet();
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount.get();
    }

    public void incTotalBytesRecv(int n) {
        this.totalBytesRecv.addAndGet(n);
    }

    public long getTotalBytesRecv() {
        return this.totalBytesRecv.get();
    }

    public void incTotalBytesSent(int n) {
        this.totalBytesSent.addAndGet(n);
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent.get();
    }

    public void setContentLength(long n) {
        this.contentLength.set(n);
    }

    public void incTotalContentLength(long n) {
        this.totalContentLength.addAndGet(n);
    }

    public long getContentLength() {
        return this.contentLength.get();
    }

    public long getTotalContentLength() {
        return this.totalContentLength.get();
    }

    public void setServerName(String serverName) {
        this.serverNameRef.set(serverName);
    }

    public String getServerName() {
        return this.serverNameRef.get();
    }

    public ProtocolVersion getVersion() {
        return this.versionRef.get();
    }

    public void setVersion(ProtocolVersion version) {
        this.versionRef.set(version);
    }

    public String toString() {
        return "Stats{successCount=" + this.successCount + ", failureCount=" + this.failureCount + ", keepAliveCount=" + this.keepAliveCount + ", serverName=" + this.serverNameRef.get() + ", totalBytesRecv=" + this.totalBytesRecv + ", totalBytesSent=" + this.totalBytesSent + ", contentLength=" + this.contentLength + '}';
    }
}

