/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicStatusLine {
    TestBasicStatusLine() {
    }

    @Test
    void testGetStatusClass() {
        StatusLine statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(100, "Continue"));
        Assertions.assertEquals((Object)StatusLine.StatusClass.INFORMATIONAL, (Object)statusLine.getStatusClass());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(200, "OK"));
        Assertions.assertEquals((Object)StatusLine.StatusClass.SUCCESSFUL, (Object)statusLine.getStatusClass());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(302, "Found"));
        Assertions.assertEquals((Object)StatusLine.StatusClass.REDIRECTION, (Object)statusLine.getStatusClass());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(409, "Conflict"));
        Assertions.assertEquals((Object)StatusLine.StatusClass.CLIENT_ERROR, (Object)statusLine.getStatusClass());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(502, "Bad Gateway"));
        Assertions.assertEquals((Object)StatusLine.StatusClass.SERVER_ERROR, (Object)statusLine.getStatusClass());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(999, "Not a status"));
        Assertions.assertEquals((Object)StatusLine.StatusClass.OTHER, (Object)statusLine.getStatusClass());
    }

    @Test
    void testGetStatusShorthand() {
        StatusLine statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(100, "Continue"));
        Assertions.assertTrue((boolean)statusLine.isInformational());
        Assertions.assertFalse((boolean)statusLine.isSuccessful());
        Assertions.assertFalse((boolean)statusLine.isError());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(200, "OK"));
        Assertions.assertTrue((boolean)statusLine.isSuccessful());
        Assertions.assertFalse((boolean)statusLine.isRedirection());
        Assertions.assertFalse((boolean)statusLine.isError());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(302, "Found"));
        Assertions.assertTrue((boolean)statusLine.isRedirection());
        Assertions.assertFalse((boolean)statusLine.isClientError());
        Assertions.assertFalse((boolean)statusLine.isError());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(409, "Conflict"));
        Assertions.assertTrue((boolean)statusLine.isClientError());
        Assertions.assertTrue((boolean)statusLine.isError());
        Assertions.assertFalse((boolean)statusLine.isServerError());
        statusLine = new StatusLine((HttpResponse)new BasicHttpResponse(502, "Bad Gateway"));
        Assertions.assertTrue((boolean)statusLine.isServerError());
        Assertions.assertTrue((boolean)statusLine.isError());
        Assertions.assertFalse((boolean)statusLine.isSuccessful());
    }
}

