/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.network.messages;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgInitMessageBuilder;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class CmgInitMessageDeserializer
implements MessageDeserializer<CmgInitMessage> {
    private final CmgInitMessageBuilder msg;

    CmgInitMessageDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.cmgInitMessage();
    }

    @Override
    public Class<CmgInitMessage> klass() {
        return CmgInitMessage.class;
    }

    @Override
    public CmgInitMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readUuid("clusterId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.clusterId((UUID)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("clusterName");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.clusterName((String)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readSet("cmgNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.cmgNodes((Set<String>)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("initialClusterConfiguration");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initialClusterConfiguration((String)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readSet("metaStorageNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.metaStorageNodes((Set<String>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CmgInitMessage.class);
    }
}

