/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.bifromq.basekv.localengine.ICPableKVSpace;
import org.apache.bifromq.basekv.localengine.IKVSpaceCheckpoint;
import org.apache.bifromq.basekv.localengine.IKVSpaceMigratableWriter;
import org.apache.bifromq.basekv.localengine.IKVSpaceRefreshableReader;
import org.apache.bifromq.basekv.localengine.IRestoreSession;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.RestoreMode;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.metrics.GeneralKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.IKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceMeters;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.AdaptiveWriteBudget;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceCheckpoint;
import org.apache.bifromq.basekv.localengine.rocksdb.IteratorOptions;
import org.apache.bifromq.basekv.localengine.rocksdb.Keys;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBCPableKVEngine;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBCPableKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBHelper;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpace;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceCheckpoint;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceMigratableWriter;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceReader;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceWriterHelper;
import org.apache.bifromq.basekv.localengine.rocksdb.metrics.RocksDBKVSpaceMetric;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

class RocksDBCPableKVSpace
extends RocksDBKVSpace
implements ICPableKVSpace {
    public static final String ACTIVE_GEN_POINTER = "ACTIVE";
    private static final String CP_SUFFIX = ".cp";
    private final RocksDBCPableKVEngine engine;
    private final File cpRootDir;
    private final WriteOptions writeOptions;
    private final AtomicReference<String> latestCheckpointId = new AtomicReference();
    private final Cache<String, IRocksDBKVSpaceCheckpoint> checkpoints;
    private final MetricManager metricMgr;
    private final AtomicReference<RocksDBCPableKVSpaceEpochHandle> active = new AtomicReference();
    private File currentDBDir;
    private IKVSpaceCheckpoint latestCheckpoint;

    RocksDBCPableKVSpace(String id, Struct conf, RocksDBCPableKVEngine engine, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        super(id, conf, engine, onDestroy, opMeters, logger, tags);
        this.engine = engine;
        this.cpRootDir = new File(StructUtil.strVal((Struct)conf, (String)"dbCheckpointRootDir"), id);
        this.checkpoints = Caffeine.newBuilder().weakValues().build();
        this.writeOptions = new WriteOptions().setDisableWAL(true);
        Files.createDirectories(this.cpRootDir.getAbsoluteFile().toPath(), new FileAttribute[0]);
        this.metricMgr = new MetricManager(tags);
        Files.createDirectories(this.spaceRootDir().getAbsoluteFile().toPath(), new FileAttribute[0]);
        this.initOrMigrateCurrentDBDir();
    }

    @Override
    protected WriteOptions writeOptions() {
        return this.writeOptions;
    }

    @Override
    protected RocksDBCPableKVSpaceEpochHandle handle() {
        return this.active.get();
    }

    public String checkpoint() {
        return (String)this.metricMgr.checkpointTimer.record(() -> {
            RocksDBCPableKVSpace rocksDBCPableKVSpace = this;
            synchronized (rocksDBCPableKVSpace) {
                IRocksDBKVSpaceCheckpoint cp = this.doCheckpoint();
                this.checkpoints.put((Object)cp.cpId(), (Object)cp);
                this.latestCheckpoint = cp;
                return cp.cpId();
            }
        });
    }

    public Optional<IKVSpaceCheckpoint> openCheckpoint(String checkpointId) {
        IRocksDBKVSpaceCheckpoint cp = (IRocksDBKVSpaceCheckpoint)this.checkpoints.getIfPresent((Object)checkpointId);
        return Optional.ofNullable(cp);
    }

    public IRestoreSession startRestore(IRestoreSession.FlushListener flushListener) {
        return new RestoreSession(RestoreMode.Replace, flushListener, this.logger);
    }

    public IRestoreSession startReceiving(IRestoreSession.FlushListener flushListener) {
        return new RestoreSession(RestoreMode.Overlay, flushListener, this.logger);
    }

    public IKVSpaceMigratableWriter toWriter() {
        return new RocksDBKVSpaceMigratableWriter(this.id, this.active.get(), this.engine, this.writeOptions(), this.syncContext, this.writeStats.newRecorder(), this::publishMetadata, this.opMeters, this.logger);
    }

    @Override
    protected void doClose() {
        this.logger.debug("Flush RocksDBCPableKVSpace[{}] before closing", (Object)this.id);
        try (FlushOptions flushOptions = new FlushOptions().setWaitForFlush(true);){
            this.active.get().db.flush(flushOptions);
        }
        catch (Throwable e) {
            this.logger.error("Flush RocksDBCPableKVSpace[{}] error", (Object)this.id, (Object)e);
        }
        this.metricMgr.close();
        this.checkpoints.asMap().forEach((cpId, cp) -> cp.close());
        this.writeOptions.close();
        RocksDBCPableKVSpaceEpochHandle h = this.active.get();
        if (h != null) {
            h.close();
        }
        super.doClose();
    }

    @Override
    protected void doDestroy() {
        try {
            RocksDBHelper.deleteDir(this.cpRootDir.toPath());
        }
        catch (IOException e) {
            this.logger.error("Failed to delete checkpoint root dir: {}", (Object)this.cpRootDir, (Object)e);
        }
        finally {
            super.doDestroy();
        }
    }

    @Override
    protected void doOpen() {
        try {
            this.active.set(this.newEpochHandle(this.currentDBDir));
            this.cleanInactiveOnStartup();
            this.loadLatestCheckpoint();
            super.doOpen();
        }
        catch (Throwable e) {
            throw new KVEngineException("Failed to open CPable KVSpace", e);
        }
    }

    private RocksDBCPableKVSpaceEpochHandle newEpochHandle(File dir) {
        return new RocksDBCPableKVSpaceEpochHandle(this.id, dir, this.conf, this::isRetired, this.logger, this.tags);
    }

    private IRocksDBKVSpaceCheckpoint doCheckpoint() {
        String cpId = this.genCheckpointId();
        File cpDir = Paths.get(this.cpRootDir.getAbsolutePath(), cpId).toFile();
        try {
            this.logger.debug("KVSpace[{}] checkpoint start: checkpointId={}", (Object)this.id, (Object)cpId);
            RocksDBCPableKVSpaceEpochHandle currentHandle = this.active.get();
            currentHandle.db.put(currentHandle.cf, Keys.LATEST_CP_KEY, cpId.getBytes());
            currentHandle.checkpoint.createCheckpoint(cpDir.toString());
            this.latestCheckpointId.set(cpId);
            return new RocksDBKVSpaceCheckpoint(this.id, cpId, cpDir, this::isLatest, this.opMeters, this.logger);
        }
        catch (Throwable e) {
            throw new KVEngineException("Checkpoint key range error", e);
        }
    }

    private IRocksDBKVSpaceCheckpoint doLoadLatestCheckpoint() {
        RocksDBCPableKVSpaceEpochHandle currentHandle = this.active.get();
        byte[] cpIdBytes = currentHandle.db.get(currentHandle.cf, Keys.LATEST_CP_KEY);
        if (cpIdBytes != null) {
            try {
                String cpId = new String(cpIdBytes, StandardCharsets.UTF_8);
                File cpDir = Paths.get(this.cpRootDir.getAbsolutePath(), cpId).toFile();
                for (String obsoleteId : this.obsoleteCheckpoints(cpId)) {
                    try {
                        this.cleanCheckpoint(obsoleteId);
                    }
                    catch (Throwable e) {
                        this.logger.error("Clean checkpoint[{}] for kvspace[{}] error", new Object[]{obsoleteId, this.id, e});
                    }
                }
                this.logger.debug("Load latest checkpoint[{}] of kvspace[{}] in engine[{}] at path[{}]", new Object[]{cpId, this.id, this.engine.id(), cpDir});
                this.latestCheckpointId.set(cpId);
                return new RocksDBKVSpaceCheckpoint(this.id, cpId, cpDir, this::isLatest, this.opMeters, this.logger);
            }
            catch (Throwable e) {
                this.logger.warn("Failed to load latest checkpoint, checkpoint now", e);
            }
        }
        return this.doCheckpoint();
    }

    private void loadLatestCheckpoint() {
        IRocksDBKVSpaceCheckpoint checkpoint = this.doLoadLatestCheckpoint();
        assert (!this.checkpoints.asMap().containsKey(checkpoint.cpId()));
        this.checkpoints.put((Object)checkpoint.cpId(), (Object)checkpoint);
        this.latestCheckpoint = checkpoint;
    }

    private String genCheckpointId() {
        return String.valueOf(UUID.randomUUID()) + CP_SUFFIX;
    }

    private boolean isLatest(String cpId) {
        return cpId.equals(this.latestCheckpointId.get());
    }

    private File checkpointDir(String cpId) {
        return Paths.get(this.cpRootDir.getAbsolutePath(), cpId).toFile();
    }

    private boolean isRetired(String genId) {
        File pointer = new File(this.spaceRootDir(), ACTIVE_GEN_POINTER);
        try {
            if (!pointer.exists()) {
                return true;
            }
            String activeUuid = Files.readString(pointer.toPath()).trim();
            return !genId.equals(activeUuid);
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private Iterable<String> obsoleteCheckpoints(String skipId) {
        File[] cpDirList = this.cpRootDir.listFiles();
        if (cpDirList == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(cpDirList).filter(File::isDirectory).map(File::getName).filter(cpId -> !skipId.equals(cpId)).collect(Collectors.toList());
    }

    private void cleanCheckpoint(String cpId) {
        this.logger.debug("Delete checkpoint[{}] of kvspace[{}]", (Object)cpId, (Object)this.id);
        try {
            RocksDBHelper.deleteDir(this.checkpointDir(cpId).toPath());
        }
        catch (IOException e) {
            this.logger.error("Failed to clean checkpoint[{}] for kvspace[{}] at path:{}", new Object[]{cpId, this.id, this.checkpointDir(cpId)});
        }
    }

    private void switchTo(RocksDBCPableKVSpaceEpochHandle handle) {
        this.syncContext.mutator().run(() -> {
            this.active.set(handle);
            this.updateCurrentDBDir(handle.dir);
            this.reloadMetadata();
            return true;
        });
    }

    private void initOrMigrateCurrentDBDir() {
        File spaceRoot = this.spaceRootDir();
        File pointer = new File(spaceRoot, ACTIVE_GEN_POINTER);
        if (pointer.exists()) {
            try {
                File dir;
                String uuid = Files.readString(pointer.toPath()).trim();
                if (!uuid.isEmpty() && (dir = new File(spaceRoot, uuid)).exists() && dir.isDirectory()) {
                    this.currentDBDir = dir;
                    return;
                }
            }
            catch (Throwable t) {
                this.logger.warn("Failed to read {} for {}, create new generation", new Object[]{ACTIVE_GEN_POINTER, this.id, t});
            }
            File newGen = new File(spaceRoot, UUID.randomUUID().toString());
            Files.createDirectories(newGen.toPath(), new FileAttribute[0]);
            this.updateCurrentDBDir(newGen);
            return;
        }
        String[] children = spaceRoot.list();
        if (children == null || children.length == 0) {
            File newGen = new File(spaceRoot, UUID.randomUUID().toString());
            Files.createDirectories(newGen.toPath(), new FileAttribute[0]);
            this.updateCurrentDBDir(newGen);
            return;
        }
        File newGen = new File(spaceRoot, UUID.randomUUID().toString());
        Files.createDirectories(newGen.toPath(), new FileAttribute[0]);
        File[] entries = spaceRoot.listFiles();
        if (entries != null) {
            for (File entry : entries) {
                if (entry.getName().equals(ACTIVE_GEN_POINTER)) continue;
                try {
                    Path target = new File(newGen, entry.getName()).toPath();
                    Files.move(entry.toPath(), target, new CopyOption[0]);
                }
                catch (Throwable moveEx) {
                    this.logger.warn("Failed to move legacy entry {} for space[{}] by Files.move, fallback to rename", new Object[]{entry.getAbsolutePath(), this.id, moveEx});
                    boolean renamed = entry.renameTo(new File(newGen, entry.getName()));
                    if (renamed) continue;
                    this.logger.warn("Failed to move legacy entry {} for space[{}]", (Object)entry.getAbsolutePath(), (Object)this.id);
                }
            }
        }
        this.updateCurrentDBDir(newGen);
    }

    private void updateCurrentDBDir(File newDir) {
        this.currentDBDir = newDir;
        File pointer = new File(this.spaceRootDir(), ACTIVE_GEN_POINTER);
        try {
            Files.writeString(pointer.toPath(), (CharSequence)newDir.getName(), new OpenOption[0]);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to update {} pointer for {}", new Object[]{ACTIVE_GEN_POINTER, this.id, t});
        }
    }

    private void cleanInactiveOnStartup() {
        File[] files;
        String activeUuid;
        File pointer = new File(this.spaceRootDir(), ACTIVE_GEN_POINTER);
        if (!pointer.exists()) {
            return;
        }
        try {
            activeUuid = Files.readString(pointer.toPath()).trim();
        }
        catch (Throwable t) {
            return;
        }
        if (activeUuid.isEmpty()) {
            return;
        }
        File root = this.spaceRootDir();
        File[] children = root.listFiles(File::isDirectory);
        if (children != null) {
            for (File c : children) {
                if (c.getName().equals(activeUuid)) continue;
                RocksDBHelper.deleteDir(c.toPath());
            }
        }
        if ((files = root.listFiles(File::isFile)) != null) {
            for (File f : files) {
                if (f.getName().equals(ACTIVE_GEN_POINTER)) continue;
                Files.deleteIfExists(f.toPath());
            }
        }
    }

    public IKVSpaceRefreshableReader reader() {
        return new RocksDBKVSpaceReader(this.id, this.opMeters, this.logger, this.syncContext.refresher(), this::handle, () -> this.currentMetadata(), new IteratorOptions(true, 0L));
    }

    private class MetricManager {
        private final Gauge checkpointGauge;
        private final Timer checkpointTimer;

        MetricManager(String ... metricTags) {
            Tags tags = Tags.of((String[])metricTags);
            this.checkpointGauge = KVSpaceMeters.getGauge((String)RocksDBCPableKVSpace.this.id, (IKVSpaceMetric)GeneralKVSpaceMetric.CheckpointNumGauge, () -> RocksDBCPableKVSpace.this.checkpoints.estimatedSize(), (Tags)tags);
            this.checkpointTimer = KVSpaceMeters.getTimer((String)RocksDBCPableKVSpace.this.id, (IKVSpaceMetric)RocksDBKVSpaceMetric.CheckpointTimer, (Tags)tags);
        }

        void close() {
            this.checkpointGauge.close();
            this.checkpointTimer.close();
        }
    }

    private class RestoreSession
    implements IRestoreSession {
        private final File stagingDir;
        private final RocksDBKVSpaceWriterHelper helper;
        private final AdaptiveWriteBudget adaptiveWriteBudget = new AdaptiveWriteBudget();
        private final IRestoreSession.FlushListener flushListener;
        private final Logger logger;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final RocksDBCPableKVSpaceEpochHandle stagingHandle;
        private int ops = 0;
        private long bytes = 0L;
        private long batchStartNanos = -1L;

        RestoreSession(RestoreMode mode, IRestoreSession.FlushListener flushListener, Logger logger) {
            this.flushListener = flushListener;
            this.logger = logger;
            try {
                this.stagingDir = Paths.get(RocksDBCPableKVSpace.this.spaceRootDir().getAbsolutePath(), UUID.randomUUID().toString()).toFile();
                if (mode == RestoreMode.Overlay) {
                    RocksDBCPableKVSpace.this.active.get().checkpoint.createCheckpoint(this.stagingDir.toString());
                } else {
                    Files.createDirectories(this.stagingDir.toPath(), new FileAttribute[0]);
                }
                this.stagingHandle = new RocksDBCPableKVSpaceEpochHandle(RocksDBCPableKVSpace.this.id, this.stagingDir, RocksDBCPableKVSpace.this.conf, RocksDBCPableKVSpace.this::isRetired, logger, RocksDBCPableKVSpace.this.tags);
                this.helper = new RocksDBKVSpaceWriterHelper(this.stagingHandle.db, RocksDBCPableKVSpace.this.writeOptions);
            }
            catch (Throwable t) {
                throw new KVEngineException("Begin restore failed", t);
            }
        }

        private void ensureOpen() {
            if (this.closed.get()) {
                throw new IllegalStateException("Restore session already closed");
            }
        }

        private void flushIfNeeded() {
            if (this.adaptiveWriteBudget.shouldFlush(this.ops, this.bytes)) {
                long start = this.batchStartNanos > 0L ? this.batchStartNanos : System.nanoTime();
                this.helper.flush();
                long latencyMillis = Math.max(1L, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                this.adaptiveWriteBudget.recordFlush(this.ops, this.bytes, latencyMillis);
                this.flushListener.onFlush(this.ops, this.bytes);
                this.ops = 0;
                this.bytes = 0L;
                this.batchStartNanos = -1L;
            }
        }

        public IRestoreSession put(ByteString key, ByteString value) {
            this.ensureOpen();
            try {
                this.helper.put(this.stagingHandle.cf, key, value);
                if (this.ops == 0 && this.bytes == 0L) {
                    this.batchStartNanos = System.nanoTime();
                }
                ++this.ops;
                this.bytes += (long)(key.size() + value.size());
                this.flushIfNeeded();
                return this;
            }
            catch (RocksDBException e) {
                throw new KVEngineException("Restore put failed", (Throwable)e);
            }
        }

        public IRestoreSession metadata(ByteString metaKey, ByteString metaValue) {
            this.ensureOpen();
            try {
                this.helper.metadata(this.stagingHandle.cf, metaKey, metaValue);
                return this;
            }
            catch (RocksDBException e) {
                throw new KVEngineException("Restore metadata failed", (Throwable)e);
            }
        }

        public void done() {
            if (this.closed.compareAndSet(false, true)) {
                try {
                    if (this.ops > 0 || this.bytes > 0L) {
                        long start = this.batchStartNanos > 0L ? this.batchStartNanos : System.nanoTime();
                        this.helper.flush();
                        long latencyMillis = Math.max(1L, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                        this.adaptiveWriteBudget.recordFlush(this.ops, this.bytes, latencyMillis);
                        this.ops = 0;
                        this.bytes = 0L;
                        this.batchStartNanos = -1L;
                    }
                    this.helper.done();
                    RocksDBCPableKVSpace.this.switchTo(this.stagingHandle);
                }
                catch (Throwable t) {
                    throw new KVEngineException("Restore done failed", t);
                }
            }
        }

        public void abort() {
            if (this.closed.compareAndSet(false, true)) {
                try {
                    this.helper.abort();
                }
                catch (Throwable t) {
                    this.logger.warn("Abort restore session failed", t);
                }
                try {
                    this.stagingHandle.close();
                }
                catch (Throwable t) {
                    this.logger.warn("Close staging RocksDB failed", t);
                }
                try {
                    RocksDBHelper.deleteDir(this.stagingDir.toPath());
                }
                catch (Throwable t) {
                    this.logger.warn("Delete staging dir failed: {}", (Object)this.stagingDir, (Object)t);
                }
            }
        }

        public int count() {
            return this.helper.count();
        }
    }
}

