/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.rocksdb.Keys;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

class RocksDBKVSpaceWriterHelper {
    private final RocksDB db;
    private final WriteOptions writeOptions;
    private final WriteBatch batch;
    private final Map<ColumnFamilyHandle, Consumer<Map<ByteString, ByteString>>> afterWriteCallbacks = new HashMap<ColumnFamilyHandle, Consumer<Map<ByteString, ByteString>>>();
    private final Map<ColumnFamilyHandle, Map<ByteString, ByteString>> metadataChanges = new HashMap<ColumnFamilyHandle, Map<ByteString, ByteString>>();
    private final Set<ISyncContext.IMutator> mutators = new HashSet<ISyncContext.IMutator>();

    RocksDBKVSpaceWriterHelper(RocksDB db, WriteOptions writeOptions) {
        this.db = db;
        this.writeOptions = writeOptions;
        this.batch = new WriteBatch();
    }

    void addMutator(ISyncContext.IMutator mutator) {
        this.mutators.add(mutator);
    }

    void addAfterWriteCallback(ColumnFamilyHandle cfHandle, Consumer<Map<ByteString, ByteString>> afterWrite) {
        this.afterWriteCallbacks.put(cfHandle, afterWrite);
        this.metadataChanges.put(cfHandle, new HashMap());
    }

    void metadata(ColumnFamilyHandle cfHandle, ByteString metaKey, ByteString metaValue) throws RocksDBException {
        byte[] key = Keys.toMetaKey(metaKey);
        this.batch.singleDelete(cfHandle, key);
        this.batch.put(cfHandle, key, metaValue.toByteArray());
        this.metadataChanges.computeIfPresent(cfHandle, (k, v) -> {
            v.put(metaKey, metaValue);
            return v;
        });
    }

    void insert(ColumnFamilyHandle cfHandle, ByteString key, ByteString value) throws RocksDBException {
        this.batch.put(cfHandle, Keys.toDataKey(key), value.toByteArray());
    }

    void put(ColumnFamilyHandle cfHandle, ByteString key, ByteString value) throws RocksDBException {
        byte[] dataKey = Keys.toDataKey(key);
        this.batch.singleDelete(cfHandle, dataKey);
        this.batch.put(cfHandle, dataKey, value.toByteArray());
    }

    void delete(ColumnFamilyHandle cfHandle, ByteString key) throws RocksDBException {
        this.batch.singleDelete(cfHandle, Keys.toDataKey(key));
    }

    void clear(ColumnFamilyHandle cfHandle, Boundary boundary) throws RocksDBException {
        byte[] startKey = BoundaryUtil.startKeyBytes((Boundary)boundary);
        byte[] endKey = BoundaryUtil.endKeyBytes((Boundary)boundary);
        startKey = startKey == null ? Keys.DATA_SECTION_START : Keys.toDataKey(startKey);
        endKey = endKey == null ? Keys.DATA_SECTION_END : Keys.toDataKey(endKey);
        this.batch.deleteRange(cfHandle, startKey, endKey);
    }

    void flush() {
        if (this.batch.count() == 0) {
            return;
        }
        try {
            if (this.batch.count() > 0) {
                this.db.write(this.writeOptions, this.batch);
                this.batch.clear();
            }
        }
        catch (Throwable e) {
            throw new KVEngineException("Range write error", e);
        }
    }

    void done() {
        this.runInMutators(() -> {
            try {
                if (this.batch.count() > 0) {
                    this.db.write(this.writeOptions, this.batch);
                    this.batch.clear();
                }
            }
            catch (Throwable e) {
                throw new KVEngineException("Range write error", e);
            }
            finally {
                if (this.batch.isOwningHandle()) {
                    this.batch.close();
                }
            }
            return false;
        });
        for (ColumnFamilyHandle columnFamilyHandle : this.afterWriteCallbacks.keySet()) {
            Map<ByteString, ByteString> updatedMetadata = this.metadataChanges.get(columnFamilyHandle);
            this.afterWriteCallbacks.get(columnFamilyHandle).accept(updatedMetadata);
            updatedMetadata.clear();
        }
    }

    void abort() {
        this.batch.clear();
        this.batch.close();
    }

    int count() {
        return this.batch.count();
    }

    long dataSize() {
        return this.batch.getDataSize();
    }

    boolean hasPendingMetadata() {
        return this.metadataChanges.values().stream().anyMatch(map -> !map.isEmpty());
    }

    private void runInMutators(ISyncContext.IMutation mutation) {
        if (this.mutators.isEmpty()) {
            mutation.mutate();
            return;
        }
        AtomicReference<ISyncContext.IMutation> finalRun = new AtomicReference<ISyncContext.IMutation>();
        for (ISyncContext.IMutator mutator : this.mutators) {
            if (finalRun.get() == null) {
                finalRun.set(() -> mutator.run(mutation));
                continue;
            }
            ISyncContext.IMutation innerRun = (ISyncContext.IMutation)finalRun.get();
            finalRun.set(() -> mutator.run(innerRun));
        }
        ((ISyncContext.IMutation)finalRun.get()).mutate();
    }
}

