/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.inbox.storage.proto.InboxMetadata;
import org.apache.bifromq.inbox.store.ITenantStats;
import org.apache.bifromq.inbox.store.TenantStats;
import org.apache.bifromq.inbox.store.schema.KVSchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantsStats
implements ITenantStats {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantsStats.class);
    private final Map<String, TenantStats> tenantStatsMap = new ConcurrentHashMap<String, TenantStats>();
    private final Supplier<IKVRangeRefreshableReader> readerSupplier;
    private final String[] tags;
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final AtomicBoolean draining = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final StampedLock closeLock = new StampedLock();

    TenantsStats(Supplier<IKVRangeRefreshableReader> readerSupplier, String ... tags) {
        this.readerSupplier = readerSupplier;
        this.tags = tags;
    }

    @Override
    public void addSessionCount(String tenantId, int delta) {
        this.taskQueue.offer(() -> this.doAddSessionCount(tenantId, delta));
        this.trigger();
    }

    @Override
    public void addSubCount(String tenantId, int delta) {
        this.taskQueue.offer(() -> this.doAddSubCount(tenantId, delta));
        this.trigger();
    }

    @Override
    public void toggleMetering(boolean isLeader) {
        this.taskQueue.offer(() -> this.tenantStatsMap.values().forEach(s -> s.toggleMetering(isLeader)));
        this.trigger();
    }

    @Override
    public void reset(Boundary boundary) {
        this.taskQueue.offer(() -> this.doReset(boundary));
        this.trigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        long stamp = this.closeLock.writeLock();
        try {
            if (this.closed.compareAndSet(false, true)) {
                CompletableFuture closeFuture = new CompletableFuture();
                this.taskQueue.offer(() -> {
                    try {
                        this.tenantStatsMap.values().forEach(TenantStats::destroy);
                        this.tenantStatsMap.clear();
                    }
                    finally {
                        closeFuture.complete(null);
                    }
                });
                this.trigger();
                closeFuture.join();
            }
        }
        finally {
            this.closeLock.unlock(stamp);
        }
    }

    private void trigger() {
        if (this.draining.compareAndSet(false, true)) {
            ForkJoinPool.commonPool().execute(this::drain);
        }
    }

    private void drain() {
        try {
            Runnable r;
            while ((r = this.taskQueue.poll()) != null) {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    log.warn("InboxStore tenant stats task failed", e);
                }
            }
        }
        finally {
            this.draining.set(false);
            if (!this.taskQueue.isEmpty()) {
                this.trigger();
            }
        }
    }

    private void doAddSessionCount(String tenantId, int delta) {
        if (delta == 0) {
            return;
        }
        this.tenantStatsMap.compute(tenantId, (k, v) -> {
            if (v == null) {
                if (delta < 0) {
                    return null;
                }
                v = new TenantStats(tenantId, this.getTenantUsedSpaceProvider(tenantId), this.tags);
            }
            v.addSessionCount(delta);
            if (v.isNoSession()) {
                v.destroy();
                return null;
            }
            return v;
        });
    }

    private void doAddSubCount(String tenantId, int delta) {
        if (delta == 0) {
            return;
        }
        this.tenantStatsMap.compute(tenantId, (k, v) -> {
            if (v == null) {
                if (delta < 0) {
                    return null;
                }
                v = new TenantStats(tenantId, this.getTenantUsedSpaceProvider(tenantId), this.tags);
            }
            v.addSubCount(delta);
            return v;
        });
    }

    private Supplier<Number> getTenantUsedSpaceProvider(String tenantId) {
        return () -> {
            long stamp = this.closeLock.readLock();
            if (this.closed.get()) {
                this.closeLock.unlock(stamp);
                return 0;
            }
            try {
                Long l;
                block16: {
                    Boundary tenantBoundary;
                    IKVRangeRefreshableReader reader;
                    block14: {
                        Integer n;
                        block15: {
                            reader = this.readerSupplier.get();
                            try {
                                ByteString startKey = KVSchemaUtil.tenantBeginKeyPrefix((String)tenantId);
                                ByteString endKey = BoundaryUtil.upperBound((ByteString)startKey);
                                tenantBoundary = BoundaryUtil.intersect((Boundary)reader.boundary(), (Boundary)BoundaryUtil.toBoundary((ByteString)startKey, (ByteString)endKey));
                                if (!BoundaryUtil.isNULLRange((Boundary)tenantBoundary)) break block14;
                                n = 0;
                                if (reader == null) break block15;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (reader != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    log.error("Failed to get used space for tenant:{}", (Object)tenantId, (Object)e);
                                    Integer n2 = 0;
                                    return n2;
                                }
                            }
                            reader.close();
                        }
                        return n;
                    }
                    l = reader.size(tenantBoundary);
                    if (reader == null) break block16;
                    reader.close();
                }
                return l;
            }
            finally {
                this.closeLock.unlock(stamp);
            }
        };
    }

    private void doReset(Boundary boundary) {
        this.tenantStatsMap.values().forEach(TenantStats::destroy);
        this.tenantStatsMap.clear();
        try (IKVRangeRefreshableReader reader = this.readerSupplier.get();
             IKVIterator itr = reader.iterator();){
            itr.seekToFirst();
            while (itr.isValid()) {
                String tenantId = KVSchemaUtil.parseTenantId((ByteString)itr.key());
                this.loadStats(tenantId, itr);
                itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.tenantBeginKeyPrefix((String)tenantId)));
            }
        }
        catch (Throwable e) {
            log.error("Async load inbox store tenant stats failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStats(String tenantId, IKVIterator itr) {
        String inboxId = null;
        ByteString beginKeyPrefix = KVSchemaUtil.tenantBeginKeyPrefix((String)tenantId);
        int probe = 0;
        itr.seek(beginKeyPrefix);
        while (itr.isValid() && itr.key().startsWith(beginKeyPrefix)) {
            if (KVSchemaUtil.isInboxInstanceStartKey((ByteString)itr.key())) {
                try {
                    InboxMetadata inboxMetadata = InboxMetadata.parseFrom((ByteString)itr.value());
                    if (inboxId == null || !inboxId.equals(inboxMetadata.getInboxId())) {
                        inboxId = inboxMetadata.getInboxId();
                        this.doAddSessionCount(tenantId, 1);
                    }
                    this.doAddSubCount(tenantId, inboxMetadata.getTopicFiltersCount());
                    continue;
                }
                catch (InvalidProtocolBufferException e) {
                    log.error("Unexpected error", (Throwable)e);
                    continue;
                }
                finally {
                    itr.next();
                    ++probe;
                    continue;
                }
            }
            if (probe < 20) {
                itr.next();
                ++probe;
                continue;
            }
            if (KVSchemaUtil.isInboxInstanceKey((ByteString)itr.key())) {
                itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)itr.key())));
                continue;
            }
            itr.next();
            ++probe;
        }
    }
}

