/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.store.option.KVRangeOptions;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.server.IDistServer;
import org.apache.bifromq.dist.worker.IDistWorker;
import org.apache.bifromq.plugin.eventcollector.EventCollectorManager;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.ResourceThrottlerManager;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.SettingProviderManager;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.dist.DistServerConfig;
import org.apache.bifromq.starter.config.model.dist.DistWorkerConfig;
import org.apache.bifromq.starter.module.ServiceInjector;

public class DistServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Optional<IDistServer>>(){}).toProvider(DistServerProvider.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<Optional<IDistWorker>>(){}).toProvider(DistWorkerProvider.class).in(Singleton.class);
    }

    private static class DistServerProvider
    implements Provider<Optional<IDistServer>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private DistServerProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IDistServer> get() {
            DistServerConfig serverConfig = this.config.getDistServiceConfig().getServer();
            if (!serverConfig.isEnable()) {
                return Optional.empty();
            }
            return Optional.of(IDistServer.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).distWorkerClient((IBaseKVStoreClient)this.injector.getInstance(Key.get(IBaseKVStoreClient.class, (Annotation)Names.named((String)"distWorkerClient")))).settingProvider((ISettingProvider)this.injector.getInstance(SettingProviderManager.class)).eventCollector((IEventCollector)this.injector.getInstance(EventCollectorManager.class)).workerThreads(serverConfig.getWorkerThreads()).attributes(serverConfig.getAttributes()).defaultGroupTags(serverConfig.getDefaultGroups()).build());
        }
    }

    private static class DistWorkerProvider
    implements Provider<Optional<IDistWorker>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private DistWorkerProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IDistWorker> get() {
            DistWorkerConfig workerConfig = this.config.getDistServiceConfig().getWorker();
            if (!workerConfig.isEnable()) {
                return Optional.empty();
            }
            return Optional.of(IDistWorker.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).agentHost(this.injector.getInstance(IAgentHost.class)).metaService(this.injector.getInstance(IBaseKVMetaService.class)).eventCollector((IEventCollector)this.injector.getInstance(EventCollectorManager.class)).resourceThrottler((IResourceThrottler)this.injector.getInstance(ResourceThrottlerManager.class)).distClient(this.injector.getInstance(IDistClient.class)).distWorkerClient((IBaseKVStoreClient)this.injector.getInstance(Key.get(IBaseKVStoreClient.class, (Annotation)Names.named((String)"distWorkerClient")))).workerThreads(workerConfig.getWorkerThreads()).tickerThreads(workerConfig.getTickerThreads()).bgTaskExecutor((ScheduledExecutorService)this.injector.getInstance(Key.get(ScheduledExecutorService.class, (Annotation)Names.named((String)"bgTaskScheduler")))).storeOptions(new KVRangeStoreOptions().setKvRangeOptions(new KVRangeOptions().setMaxWALFatchBatchSize(workerConfig.getMaxWALFetchSize()).setCompactWALThreshold(workerConfig.getCompactWALThreshold())).setSplitHinterFactoryConfig(workerConfig.getSplitHinterConfig().getHinters()).setDataEngineType(workerConfig.getDataEngineConfig().getType()).setDataEngineConf(workerConfig.getDataEngineConfig().toStruct()).setWalEngineType(workerConfig.getWalEngineConfig().getType()).setWalEngineConf(workerConfig.getWalEngineConfig().toStruct())).minGCInterval(Duration.ofSeconds(workerConfig.getMinGCIntervalSeconds())).maxGCInterval(Duration.ofSeconds(workerConfig.getMaxGCIntervalSeconds())).bootstrapDelay(Duration.ofMillis(workerConfig.getBalanceConfig().getBootstrapDelayInMS())).zombieProbeDelay(Duration.ofMillis(workerConfig.getBalanceConfig().getZombieProbeDelayInMS())).balancerRetryDelay(Duration.ofMillis(workerConfig.getBalanceConfig().getRetryDelayInMS())).balancerFactoryConfig(workerConfig.getBalanceConfig().getBalancers()).subBrokerManager(this.injector.getInstance(ISubBrokerManager.class)).settingProvider((ISettingProvider)this.injector.getInstance(SettingProviderManager.class)).attributes(workerConfig.getAttributes()).build());
        }
    }
}

