/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.server;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.base.util.FutureTracker;
import org.apache.bifromq.baserpc.metrics.RPCMetric;
import org.apache.bifromq.baserpc.server.AbstractStreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractResponsePipeline<RequestT, ResponseT>
extends AbstractStreamObserver<RequestT, ResponseT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractResponsePipeline.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final FutureTracker futureTracker = new FutureTracker();

    protected AbstractResponsePipeline(StreamObserver<ResponseT> responseObserver) {
        super(responseObserver);
        this.responseObserver.setOnCancelHandler(this::cleanup);
    }

    public final void onError(Throwable t) {
        if (this.closed.compareAndSet(false, true)) {
            this.cleanup();
        }
    }

    public final void onCompleted() {
        if (this.closed.compareAndSet(false, true)) {
            this.cleanup();
        }
    }

    public final boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.close(null);
    }

    private void close(Throwable t) {
        if (this.closed.compareAndSet(false, true)) {
            if (t != null) {
                log.debug("Close pipeline@{} by error", (Object)this.hashCode(), (Object)t);
                this.responseObserver.onError(t);
            } else {
                log.trace("Close pipeline@{} normally", (Object)this.hashCode());
                this.responseObserver.onCompleted();
            }
            this.cleanup();
        }
    }

    protected abstract CompletableFuture<ResponseT> handleRequest(String var1, RequestT var2);

    final CompletableFuture<ResponseT> startHandlingRequest(RequestT request) {
        log.trace("Start handling request in pipeline@{}: request={}", (Object)this.hashCode(), request);
        this.meter.recordCount(RPCMetric.PipelineReqReceivedCount);
        Timer.Sample sample = Timer.start();
        CompletableFuture respFuture = this.futureTracker.track(this.handleRequest(this.tenantId, request));
        respFuture.whenComplete((resp, e) -> {
            sample.stop(this.meter.timer(RPCMetric.PipelineReqProcessTime));
            if (e != null) {
                this.meter.recordCount(RPCMetric.PipelineReqFailCount);
                this.fail((Throwable)e);
            } else {
                log.trace("Request handling in pipeline@{}: request={}", (Object)this.hashCode(), request);
                this.meter.recordCount(RPCMetric.PipelineReqFulfillCount);
            }
        });
        return respFuture;
    }

    final void emitResponse(RequestT req, ResponseT resp) {
        if (!this.isClosed()) {
            log.trace("Response sent in pipeline@{}: request={}, response={}", new Object[]{this.hashCode(), req, resp});
            this.responseObserver.onNext(resp);
        } else {
            log.trace("Response dropped due to pipeline@{} has been closed: request={}, response={}", new Object[]{this.hashCode(), req, resp});
        }
    }

    protected void afterClose() {
    }

    private void fail(Throwable throwable) {
        if (!this.isClosed()) {
            if (throwable instanceof CancellationException) {
                log.trace("Pipeline@{} closed due to request handler being canceled", (Object)this.hashCode(), (Object)throwable);
                this.close((Throwable)Status.CANCELLED.asRuntimeException());
            } else {
                log.trace("Pipeline@{} closed due to request handler failure", (Object)this.hashCode(), (Object)throwable);
                this.close((Throwable)Status.UNAVAILABLE.asRuntimeException());
            }
        } else {
            log.trace("Pipeline@{} has been closed", (Object)this.hashCode(), (Object)throwable);
        }
    }

    private void cleanup() {
        this.afterClose();
        this.futureTracker.stop();
    }
}

