/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv;

import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import java.util.HashMap;
import org.apache.bifromq.basekv.store.proto.BaseKVStoreServiceGrpc;
import org.apache.bifromq.baserpc.BluePrint;

public class RPCBluePrint {
    public static ServerServiceDefinition scope(ServerServiceDefinition definition, String clusterId) {
        String serviceName = RPCBluePrint.toScopedServiceName(clusterId, definition.getServiceDescriptor().getName());
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)serviceName);
        for (ServerMethodDefinition origMethodDef : definition.getMethods()) {
            MethodDescriptor methodDesc = origMethodDef.getMethodDescriptor().toBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)origMethodDef.getMethodDescriptor().getBareMethodName())).build();
            builder.addMethod(methodDesc, origMethodDef.getServerCallHandler());
        }
        return builder.build();
    }

    public static BluePrint build(String clusterId) {
        ServiceDescriptor orig = BaseKVStoreServiceGrpc.getServiceDescriptor();
        String serviceName = RPCBluePrint.toScopedServiceName(clusterId, orig.getName());
        ServiceDescriptor.Builder builder = ServiceDescriptor.newBuilder((String)serviceName).setSchemaDescriptor(orig.getSchemaDescriptor());
        HashMap<MethodDescriptor, MethodDescriptor> methodMap = new HashMap<MethodDescriptor, MethodDescriptor>();
        for (MethodDescriptor origMethodDesc : orig.getMethods()) {
            MethodDescriptor scopedMethodDesc = origMethodDesc.toBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)origMethodDesc.getBareMethodName())).build();
            builder.addMethod(scopedMethodDesc);
            methodMap.put(origMethodDesc, scopedMethodDesc);
        }
        ServiceDescriptor serviceDesc = builder.build();
        return BluePrint.builder().serviceDescriptor(serviceDesc).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getBootstrapMethod()), (BluePrint.MethodSemantic)BluePrint.DDUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getRecoverMethod()), (BluePrint.MethodSemantic)BluePrint.DDUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getZombieQuitMethod()), (BluePrint.MethodSemantic)BluePrint.DDUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getChangeReplicaConfigMethod()), (BluePrint.MethodSemantic)BluePrint.DDUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getSplitMethod()), (BluePrint.MethodSemantic)BluePrint.DDUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getMergeMethod()), (BluePrint.MethodSemantic)BluePrint.DDUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getTransferLeadershipMethod()), (BluePrint.MethodSemantic)BluePrint.DDUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getExecuteMethod()), (BluePrint.MethodSemantic)BluePrint.DDPipelineUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getQueryMethod()), (BluePrint.MethodSemantic)BluePrint.DDPipelineUnaryMethod.getInstance()).methodSemantic((MethodDescriptor)methodMap.get(BaseKVStoreServiceGrpc.getLinearizedQueryMethod()), (BluePrint.MethodSemantic)BluePrint.DDPipelineUnaryMethod.getInstance()).build();
    }

    public static String toScopedFullMethodName(String clusterId, String fullMethodName) {
        return clusterId + "@" + fullMethodName;
    }

    private static String toScopedServiceName(String clusterId, String serviceName) {
        return clusterId + "@" + serviceName;
    }
}

