/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.google.protobuf.ProtocolStringList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.dist.worker.TopicIndex;
import org.apache.bifromq.dist.worker.cache.IMatchedRoutes;
import org.apache.bifromq.dist.worker.cache.ITenantRouteCache;
import org.apache.bifromq.dist.worker.cache.ITenantRouteMatcher;
import org.apache.bifromq.dist.worker.cache.RouteCacheKey;
import org.apache.bifromq.dist.worker.cache.task.AddRoutesTask;
import org.apache.bifromq.dist.worker.cache.task.LoadEntryTask;
import org.apache.bifromq.dist.worker.cache.task.RefreshEntriesTask;
import org.apache.bifromq.dist.worker.cache.task.ReloadEntryTask;
import org.apache.bifromq.dist.worker.cache.task.RemoveRoutesTask;
import org.apache.bifromq.dist.worker.cache.task.TenantRouteCacheTask;
import org.apache.bifromq.dist.worker.schema.cache.GroupMatching;
import org.apache.bifromq.dist.worker.schema.cache.Matching;
import org.apache.bifromq.dist.worker.schema.cache.NormalMatching;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.sysprops.props.DistMaxCachedRoutesPerTenant;
import org.apache.bifromq.type.RouteMatcher;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TenantRouteCache
implements ITenantRouteCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantRouteCache.class);
    private final String tenantId;
    private final ISettingProvider settingProvider;
    private final ITenantRouteMatcher matcher;
    private final AsyncLoadingCache<RouteCacheKey, IMatchedRoutes> routesCache;
    private final TopicIndex<RouteCacheKey> index;
    private final Executor matchExecutor;
    private final ConcurrentLinkedDeque<TenantRouteCacheTask> tasks = new ConcurrentLinkedDeque();
    private final AtomicBoolean taskRunning = new AtomicBoolean(false);
    private final String[] tags;

    TenantRouteCache(KVRangeId rangeId, String tenantId, ITenantRouteMatcher matcher, ISettingProvider settingProvider, Duration expiryAfterAccess, Duration fanoutCheckInterval, Executor matchExecutor) {
        this(rangeId, tenantId, matcher, settingProvider, expiryAfterAccess, fanoutCheckInterval, Ticker.systemTicker(), matchExecutor);
    }

    TenantRouteCache(KVRangeId rangeId, final String tenantId, ITenantRouteMatcher matcher, final ISettingProvider settingProvider, Duration expiryAfterAccess, Duration fanoutCheckInterval, Ticker ticker, Executor matchExecutor) {
        this.tenantId = tenantId;
        this.matcher = matcher;
        this.matchExecutor = matchExecutor;
        this.settingProvider = settingProvider;
        this.index = new TopicIndex();
        this.routesCache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).ticker(ticker).executor(matchExecutor).maximumWeight(((Long)DistMaxCachedRoutesPerTenant.INSTANCE.get()).longValue()).weigher((Weigher)new Weigher<RouteCacheKey, IMatchedRoutes>(){

            public @NonNegative int weigh(RouteCacheKey key, IMatchedRoutes value) {
                return Math.max(1, value.routes().size());
            }
        }).expireAfterAccess(expiryAfterAccess).refreshAfterWrite(fanoutCheckInterval).removalListener((key, value, cause) -> this.index.remove(key.topic, (RouteCacheKey)key)).recordStats().buildAsync((AsyncCacheLoader)new AsyncCacheLoader<RouteCacheKey, IMatchedRoutes>(){

            public CompletableFuture<IMatchedRoutes> asyncLoad(RouteCacheKey key, Executor executor) {
                LoadEntryTask task = LoadEntryTask.of(key.topic, key);
                TenantRouteCache.this.submitCacheTask(task);
                return task.future;
            }

            public CompletableFuture<IMatchedRoutes> asyncReload(RouteCacheKey key, @NonNull IMatchedRoutes oldValue, Executor executor) {
                int maxGroupFanouts;
                int maxPersistentFanouts = (Integer)settingProvider.provide(Setting.MaxPersistentFanout, tenantId);
                if (oldValue.adjust(maxPersistentFanouts, maxGroupFanouts = ((Integer)settingProvider.provide(Setting.MaxGroupFanout, tenantId)).intValue()) == IMatchedRoutes.AdjustResult.ReloadNeeded) {
                    ReloadEntryTask task = ReloadEntryTask.of(key.topic, key, maxPersistentFanouts, maxGroupFanouts);
                    TenantRouteCache.this.submitCacheTask(task);
                    return task.future;
                }
                return CompletableFuture.completedFuture(oldValue);
            }
        });
        this.tags = new String[]{"id", KVRangeIdUtil.toString((KVRangeId)rangeId)};
        ITenantMeter.counting((String)tenantId, (TenantMetric)TenantMetric.MqttRouteCacheHitCount, (Object)this.routesCache.synchronous(), cache -> cache.stats().hitCount(), (String[])this.tags);
        ITenantMeter.counting((String)tenantId, (TenantMetric)TenantMetric.MqttRouteCacheMissCount, (Object)this.routesCache.synchronous(), cache -> cache.stats().missCount(), (String[])this.tags);
        ITenantMeter.counting((String)tenantId, (TenantMetric)TenantMetric.MqttRouteCacheEvictCount, (Object)this.routesCache.synchronous(), cache -> cache.stats().evictionCount(), (String[])this.tags);
        ITenantMeter.gauging((String)tenantId, (TenantMetric)TenantMetric.MqttRouteCacheSize, () -> ((LoadingCache)this.routesCache.synchronous()).estimatedSize(), (String[])this.tags);
    }

    @Override
    public boolean isCached(List<String> filterLevels) {
        return !this.index.match(filterLevels).isEmpty();
    }

    @Override
    public void refresh(RefreshEntriesTask task) {
        this.submitCacheTask(task);
    }

    private void submitCacheTask(TenantRouteCacheTask task) {
        this.tasks.add(task);
        this.tryScheduleTask();
    }

    private void tryScheduleTask() {
        if (this.taskRunning.compareAndSet(false, true)) {
            this.matchExecutor.execute(this::runTaskLoop);
        }
    }

    private void runTaskLoop() {
        TenantRouteCacheTask task;
        ArrayList<CompletableFuture<Void>> loadFutures = new ArrayList<CompletableFuture<Void>>(this.tasks.size());
        int maxPersistentFanouts = (Integer)this.settingProvider.provide(Setting.MaxPersistentFanout, this.tenantId);
        int maxGroupFanouts = (Integer)this.settingProvider.provide(Setting.MaxGroupFanout, this.tenantId);
        block17: while ((task = this.tasks.poll()) != null) {
            switch (task.type()) {
                case Load: {
                    LoadEntryTask loadEntryTask = (LoadEntryTask)task;
                    loadFutures.add(CompletableFuture.runAsync(() -> {
                        String topic = loadEntryTask.topic;
                        RouteCacheKey cacheKey = loadEntryTask.cacheKey;
                        Map<String, IMatchedRoutes> results = this.matcher.matchAll(Collections.singleton(topic), maxPersistentFanouts, maxGroupFanouts);
                        IMatchedRoutes matchedRoutes = results.get(topic);
                        cacheKey.cachedMatchedRoutes.set(matchedRoutes);
                        this.index.add(cacheKey.topic, cacheKey);
                        loadEntryTask.future.complete(matchedRoutes);
                    }, this.matchExecutor));
                    continue block17;
                }
                case Reload: {
                    ReloadEntryTask reloadEntryTask = (ReloadEntryTask)task;
                    loadFutures.add(CompletableFuture.runAsync(() -> {
                        String topic = reloadEntryTask.topic;
                        RouteCacheKey cacheKey = reloadEntryTask.cacheKey;
                        Map<String, IMatchedRoutes> results = this.matcher.matchAll(Collections.singleton(topic), reloadEntryTask.maxPersistentFanouts, reloadEntryTask.maxGroupFanouts);
                        IMatchedRoutes matchedRoutes = results.get(topic);
                        cacheKey.cachedMatchedRoutes.set(matchedRoutes);
                        reloadEntryTask.future.complete(matchedRoutes);
                    }, this.matchExecutor));
                    continue block17;
                }
                case AddRoutes: 
                case RemoveRoutes: {
                    if (!loadFutures.isEmpty()) {
                        this.tasks.addFirst(task);
                        break block17;
                    }
                    switch (task.type()) {
                        case AddRoutes: {
                            Set<RouteCacheKey> keys;
                            ProtocolStringList filterLevels;
                            AddRoutesTask addTask = (AddRoutesTask)task;
                            block18: for (RouteMatcher topicFilter : addTask.routes.keySet()) {
                                Set newMatchings = (Set)addTask.routes.get(topicFilter);
                                filterLevels = topicFilter.getFilterLevelList();
                                keys = this.index.match((List<String>)filterLevels);
                                switch (topicFilter.getType()) {
                                    case Normal: {
                                        for (RouteCacheKey cacheKey : keys) {
                                            for (Matching matching : newMatchings) {
                                                cacheKey.cachedMatchedRoutes.get().addNormalMatching((NormalMatching)matching);
                                            }
                                        }
                                        continue block18;
                                    }
                                    case OrderedShare: 
                                    case UnorderedShare: {
                                        for (RouteCacheKey cacheKey : keys) {
                                            for (Matching matching : newMatchings) {
                                                cacheKey.cachedMatchedRoutes.get().putGroupMatching((GroupMatching)matching);
                                            }
                                        }
                                        continue block18;
                                    }
                                }
                            }
                            continue block17;
                        }
                        case RemoveRoutes: {
                            Set<RouteCacheKey> keys;
                            ProtocolStringList filterLevels;
                            RemoveRoutesTask removeTask = (RemoveRoutesTask)task;
                            block23: for (RouteMatcher topicFilter : removeTask.routes.keySet()) {
                                Set removedMatchings = (Set)removeTask.routes.get(topicFilter);
                                filterLevels = topicFilter.getFilterLevelList();
                                keys = this.index.match((List<String>)filterLevels);
                                switch (topicFilter.getType()) {
                                    case Normal: {
                                        for (RouteCacheKey cacheKey : keys) {
                                            for (Matching matching : removedMatchings) {
                                                cacheKey.cachedMatchedRoutes.get().removeNormalMatching((NormalMatching)matching);
                                            }
                                        }
                                        continue block23;
                                    }
                                    case OrderedShare: 
                                    case UnorderedShare: {
                                        for (RouteCacheKey cacheKey : keys) {
                                            for (Matching matching : removedMatchings) {
                                                GroupMatching groupMatching = (GroupMatching)matching;
                                                if (groupMatching.receivers().isEmpty()) {
                                                    cacheKey.cachedMatchedRoutes.get().removeGroupMatching(groupMatching);
                                                    continue;
                                                }
                                                cacheKey.cachedMatchedRoutes.get().putGroupMatching(groupMatching);
                                            }
                                        }
                                        continue block23;
                                    }
                                }
                            }
                            continue block17;
                        }
                    }
                    continue block17;
                }
                default: {
                    continue block17;
                }
            }
        }
        CompletableFuture.allOf(loadFutures.toArray(new CompletableFuture[0])).whenComplete((v, e) -> {
            this.taskRunning.set(false);
            if (!this.tasks.isEmpty()) {
                this.tryScheduleTask();
            }
        });
    }

    @Override
    public CompletableFuture<Set<Matching>> getMatch(String topic, Boundary currentTenantRange) {
        return this.routesCache.get((Object)new RouteCacheKey(topic, currentTenantRange)).thenApply(IMatchedRoutes::routes);
    }

    @Override
    public void destroy() {
        this.routesCache.synchronous().asMap().keySet().forEach(key -> this.index.remove(key.topic, (RouteCacheKey)key));
        this.routesCache.synchronous().invalidateAll();
        ITenantMeter.stopCounting((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteCacheMissCount, (String[])this.tags);
        ITenantMeter.stopCounting((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteCacheHitCount, (String[])this.tags);
        ITenantMeter.stopCounting((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteCacheEvictCount, (String[])this.tags);
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteCacheSize, (String[])this.tags);
    }
}

