/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.pagination;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.entity.Identifiable;
import org.apache.polaris.core.persistence.pagination.ImmutableEntityIdToken;
import org.apache.polaris.core.persistence.pagination.Token;
import org.apache.polaris.immutables.PolarisImmutable;

@JsonSerialize(as=ImmutableEntityIdToken.class)
@JsonDeserialize(as=ImmutableEntityIdToken.class)
@PolarisImmutable
public interface EntityIdToken
extends Token {
    public static final String ID = "e";

    @JsonProperty(value="i")
    public long entityId();

    @Override
    default public String getT() {
        return ID;
    }

    @Nullable
    public static EntityIdToken fromEntity(@Nullable Identifiable entity) {
        if (entity == null) {
            return null;
        }
        return EntityIdToken.fromEntityId(entity.getId());
    }

    public static EntityIdToken fromEntityId(long entityId) {
        return ImmutableEntityIdToken.builder().entityId(entityId).build();
    }

    public static final class EntityIdTokenType
    implements Token.TokenType {
        @Override
        public String id() {
            return EntityIdToken.ID;
        }

        @Override
        public Class<? extends Token> javaType() {
            return EntityIdToken.class;
        }
    }
}

