/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.OidcSession;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class OidcSessionImpl
implements OidcSession {
    @Inject
    RoutingContext routingContext;
    @Inject
    DefaultTenantConfigResolver resolver;
    @Inject
    @IdToken
    JsonWebToken idToken;

    @Override
    public String getTenantId() {
        return (String)this.routingContext.get("tenant-id");
    }

    @Override
    public Uni<Void> logout() {
        Uni<OidcTenantConfig> oidcConfigUni = this.resolver.resolveConfig(this.routingContext);
        return oidcConfigUni.onItem().transformToUni((Function)new Function<OidcTenantConfig, Uni<? extends Void>>(){

            @Override
            public Uni<Void> apply(OidcTenantConfig oidcConfig) {
                OidcUtils.setClearSiteData(OidcSessionImpl.this.routingContext, oidcConfig);
                return OidcUtils.removeSessionCookie(OidcSessionImpl.this.routingContext, oidcConfig, OidcSessionImpl.this.resolver.getTokenStateManager());
            }
        });
    }

    @Override
    public Instant expiresAt() {
        return Instant.ofEpochSecond(this.idToken.getExpirationTime());
    }

    @Override
    public Duration validFor() {
        long nowSecs = System.currentTimeMillis() / 1000L;
        return Duration.ofSeconds(this.idToken.getExpirationTime() - nowSecs);
    }

    @Override
    public JsonWebToken getIdToken() {
        return this.idToken;
    }
}

