/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;

public class EntityResult
extends BaseResult {
    private final PolarisBaseEntity entity;

    public EntityResult(@Nonnull BaseResult.ReturnStatus errorCode, @Nullable String extraInformation) {
        super(errorCode, extraInformation);
        this.entity = null;
    }

    public EntityResult(@Nonnull PolarisBaseEntity entity) {
        super(BaseResult.ReturnStatus.SUCCESS);
        this.entity = entity;
    }

    public EntityResult(@Nonnull BaseResult.ReturnStatus errorStatus, int subTypeCode) {
        super(errorStatus, Integer.toString(subTypeCode));
        this.entity = null;
    }

    @Nullable
    public PolarisEntitySubType getAlreadyExistsEntitySubType() {
        int subTypeCode;
        if (this.getExtraInformation() == null) {
            return null;
        }
        try {
            subTypeCode = Integer.parseInt(this.getExtraInformation());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return PolarisEntitySubType.fromCode(subTypeCode);
    }

    @JsonCreator
    private EntityResult(@JsonProperty(value="returnStatus") @Nonnull BaseResult.ReturnStatus returnStatus, @JsonProperty(value="extraInformation") @Nullable String extraInformation, @JsonProperty(value="entity") @Nullable PolarisBaseEntity entity) {
        super(returnStatus, extraInformation);
        this.entity = entity;
    }

    public PolarisBaseEntity getEntity() {
        return this.entity;
    }
}

