/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobAnalyticsLogging
implements XmlSerializable<BlobAnalyticsLogging> {
    private String version;
    private boolean delete;
    private boolean read;
    private boolean write;
    private BlobRetentionPolicy retentionPolicy;

    public String getVersion() {
        return this.version;
    }

    public BlobAnalyticsLogging setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public BlobAnalyticsLogging setDelete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public boolean isRead() {
        return this.read;
    }

    public BlobAnalyticsLogging setRead(boolean read) {
        this.read = read;
        return this;
    }

    public boolean isWrite() {
        return this.write;
    }

    public BlobAnalyticsLogging setWrite(boolean write) {
        this.write = write;
        return this;
    }

    public BlobRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public BlobAnalyticsLogging setRetentionPolicy(BlobRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "BlobAnalyticsLogging" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Delete", this.delete);
        xmlWriter.writeBooleanElement("Read", this.read);
        xmlWriter.writeBooleanElement("Write", this.write);
        xmlWriter.writeXml((XmlSerializable)this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    public static BlobAnalyticsLogging fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobAnalyticsLogging.fromXml(xmlReader, null);
    }

    public static BlobAnalyticsLogging fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "BlobAnalyticsLogging" : rootElementName;
        return (BlobAnalyticsLogging)xmlReader.readObject(finalRootElementName, reader -> {
            BlobAnalyticsLogging deserializedBlobAnalyticsLogging = new BlobAnalyticsLogging();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedBlobAnalyticsLogging.version = reader.getStringElement();
                    continue;
                }
                if ("Delete".equals(elementName.getLocalPart())) {
                    deserializedBlobAnalyticsLogging.delete = reader.getBooleanElement();
                    continue;
                }
                if ("Read".equals(elementName.getLocalPart())) {
                    deserializedBlobAnalyticsLogging.read = reader.getBooleanElement();
                    continue;
                }
                if ("Write".equals(elementName.getLocalPart())) {
                    deserializedBlobAnalyticsLogging.write = reader.getBooleanElement();
                    continue;
                }
                if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedBlobAnalyticsLogging.retentionPolicy = BlobRetentionPolicy.fromXml(reader, "RetentionPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobAnalyticsLogging;
        });
    }
}

