/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi.runtime;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.BlockingOperationNotAllowedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.smallrye.mutiny.Uni;

public abstract class AbstractSecurityIdentityAssociation
implements CurrentIdentityAssociation {
    private volatile SecurityIdentity identity;
    private volatile Uni<SecurityIdentity> deferredIdentity;

    protected abstract IdentityProviderManager getIdentityProviderManager();

    public void setIdentity(SecurityIdentity identity) {
        this.identity = identity;
        this.deferredIdentity = null;
    }

    public void setIdentity(Uni<SecurityIdentity> identity) {
        this.identity = null;
        this.deferredIdentity = identity;
    }

    public Uni<SecurityIdentity> getDeferredIdentity() {
        if (this.deferredIdentity != null) {
            return this.deferredIdentity;
        }
        if (this.identity != null) {
            return Uni.createFrom().item((Object)this.identity);
        }
        this.deferredIdentity = this.getIdentityProviderManager().authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
        return this.deferredIdentity;
    }

    public SecurityIdentity getIdentity() {
        if (this.identity == null) {
            if (this.deferredIdentity != null) {
                if (BlockingOperationControl.isBlockingAllowed()) {
                    this.identity = (SecurityIdentity)this.deferredIdentity.await().indefinitely();
                } else {
                    throw new BlockingOperationNotAllowedException("Cannot call getIdentity() from the IO thread when lazy authentication is in use, as resolving the identity may block the thread. Instead you should inject the CurrentIdentityAssociation, call CurrentIdentityAssociation#getDeferredIdentity() and subscribe to the Uni.");
                }
            }
            if (this.identity == null) {
                this.identity = (SecurityIdentity)this.getIdentityProviderManager().authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE).await().indefinitely();
            }
        }
        return this.identity;
    }
}

