/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class CollectOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(CollectOperator.class);
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private boolean inited = false;
    private int currentIndex;

    public CollectOperator(OperatorContext operatorContext, List<Operator> children) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.currentIndex = 0;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.currentIndex < this.children.size();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.children.get(this.currentIndex).hasNextWithTimer()) {
            return this.children.get(this.currentIndex).nextWithTimer();
        }
        this.closeCurrentChild(this.currentIndex);
        ++this.currentIndex;
        return null;
    }

    private void closeCurrentChild(int index) throws Exception {
        this.children.get(index).close();
        this.children.set(index, null);
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.inited) {
            this.inited = true;
            for (Operator child : this.children) {
                child.isBlocked();
            }
        }
        if (this.currentIndex >= this.children.size()) {
            return NOT_BLOCKED;
        }
        return this.children.get(this.currentIndex).isBlocked();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.currentIndex >= this.children.size();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void close() throws Exception {
        int n = this.children.size();
        for (int i = this.currentIndex; i < n; ++i) {
            Operator currentChild = this.children.get(i);
            if (currentChild == null) continue;
            this.closeCurrentChild(i);
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        for (Operator child : this.children) {
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateMaxPeekMemoryWithCounter());
        }
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long maxReturnSize = 0L;
        for (Operator child : this.children) {
            maxReturnSize = Math.max(maxReturnSize, child.calculateMaxReturnSize());
        }
        return maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @TestOnly
    public List<Operator> getChildren() {
        return this.children;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

