/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ProjectOffPushDownRule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;

public class PruneApplyColumns
extends ProjectOffPushDownRule<ApplyNode> {
    public PruneApplyColumns() {
        super(Patterns.applyNode());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, ApplyNode applyNode, Set<Symbol> referencedOutputs) {
        boolean pruned;
        if (Sets.intersection(applyNode.getSubqueryAssignments().keySet(), referencedOutputs).isEmpty()) {
            return Optional.of(applyNode.getInput());
        }
        ImmutableSet.Builder requiredAssignmentsSymbols = ImmutableSet.builder();
        ImmutableMap.Builder newSubqueryAssignments = ImmutableMap.builder();
        for (Map.Entry<Symbol, ApplyNode.SetExpression> entry : applyNode.getSubqueryAssignments().entrySet()) {
            if (!referencedOutputs.contains(entry.getKey())) continue;
            requiredAssignmentsSymbols.addAll(entry.getValue().inputs());
            newSubqueryAssignments.put(entry);
        }
        Optional<PlanNode> newSubquery = Util.restrictOutputs(context.getIdAllocator(), applyNode.getSubquery(), (Set<Symbol>)requiredAssignmentsSymbols.build());
        ImmutableSet requiredInputSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll(applyNode.getCorrelation()).addAll((Iterable)requiredAssignmentsSymbols.build()).build();
        Optional<PlanNode> newInput = Util.restrictOutputs(context.getIdAllocator(), applyNode.getInput(), (Set<Symbol>)requiredInputSymbols);
        boolean bl = pruned = newSubquery.isPresent() || newInput.isPresent() || newSubqueryAssignments.buildOrThrow().size() < applyNode.getSubqueryAssignments().size();
        if (pruned) {
            return Optional.of(new ApplyNode(applyNode.getPlanNodeId(), newInput.orElse(applyNode.getInput()), newSubquery.orElse(applyNode.getSubquery()), (Map<Symbol, ApplyNode.SetExpression>)newSubqueryAssignments.buildOrThrow(), applyNode.getCorrelation(), applyNode.getOriginSubquery()));
        }
        return Optional.empty();
    }
}

