/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class FilteredList<E>
extends AbstractList<E> {
    private final Predicate<E> filter;
    private final List<E> list;
    private final Class<E> elementType;
    private final Function<Object, E> elementFunction;

    public static <E> Builder<E> create(Class<E> elementType) {
        AssertionUtils.assertArgNotNull("elementType", elementType);
        Builder builder = new Builder();
        builder.elementType = elementType;
        return builder;
    }

    public static <E> Builder<E> create() {
        Builder builder = new Builder();
        builder.elementType = Object.class;
        return builder;
    }

    protected FilteredList(Predicate<E> filter, List<E> list, Class<E> elementType, Function<Object, E> elementFunction) {
        this.filter = AssertionUtils.assertArgNotNull("filter", filter);
        this.list = AssertionUtils.assertArgNotNull("list", list);
        this.elementType = AssertionUtils.assertArgNotNull("elementType", elementType);
        this.elementFunction = elementFunction;
    }

    @Override
    public boolean add(E e) {
        if (this.filter.test(e)) {
            return this.list.add(e);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (this.filter.test(element)) {
            this.list.add(index, element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.filter.test(e)) continue;
            this.list.add(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int insertIndex = index;
        boolean modified = false;
        for (E e : c) {
            if (!this.filter.test(e)) continue;
            this.list.add(insertIndex++, e);
            modified = true;
        }
        return modified;
    }

    public boolean wouldAccept(E element) {
        return this.filter.test(element);
    }

    public Predicate<E> getFilter() {
        return this.filter;
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        if (this.filter.test(element)) {
            return this.list.set(index, element);
        }
        return this.list.get(index);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public boolean addConverted(Object element) {
        E convertedElement = this.convertElement(element);
        return this.add(convertedElement);
    }

    public FilteredList<E> addAllConverted(Collection<?> source) {
        if (source != null) {
            for (Object e : source) {
                this.addConverted(e);
            }
        }
        return this;
    }

    public FilteredList<E> addAny(Object ... values) {
        if (values != null) {
            for (Object o : values) {
                if (o == null) continue;
                if (o instanceof Collection) {
                    Collection c = (Collection)o;
                    this.addAllConverted(c);
                    continue;
                }
                if (o.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        this.addConverted(Array.get(o, i));
                    }
                    continue;
                }
                this.addConverted(o);
            }
        }
        return this;
    }

    private E convertElement(Object element) {
        if (this.elementFunction != null) {
            element = this.elementFunction.apply(element);
        }
        if (element == null) {
            if (this.elementType.isPrimitive()) {
                throw ThrowableUtils.rex("Cannot set null element for primitive type {0}", this.elementType.getName());
            }
            return null;
        }
        if (this.elementType.isInstance(element)) {
            return this.elementType.cast(element);
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to element type {1}", Utils.cn(element), Utils.cn(this.elementType));
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public static class Builder<E> {
        private Predicate<E> filter = v -> true;
        private List<E> inner;
        private Class<E> elementType;
        private Function<Object, E> elementFunction;

        public Builder<E> filter(Predicate<E> value) {
            Predicate<E> newFilter = AssertionUtils.assertArgNotNull("value", value);
            this.filter = this.filter == null ? newFilter : this.filter.and(newFilter);
            return this;
        }

        public Builder<E> inner(List<E> value) {
            this.inner = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder<E> elementFunction(Function<Object, E> value) {
            this.elementFunction = value;
            return this;
        }

        public FilteredList<E> build() {
            ArrayList list = this.inner != null ? this.inner : new ArrayList();
            return new FilteredList<E>(this.filter, list, this.elementType, this.elementFunction);
        }
    }
}

