/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotatableType;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class ConstructorInfo
extends ExecutableInfo
implements Comparable<ConstructorInfo>,
Annotatable {
    private final Constructor<?> inner;

    public static ConstructorInfo of(ClassInfo declaringClass, Constructor<?> inner) {
        AssertionUtils.assertArgNotNull("declaringClass", declaringClass);
        return declaringClass.getConstructor(inner);
    }

    public static ConstructorInfo of(Constructor<?> inner) {
        AssertionUtils.assertArgNotNull("inner", inner);
        return ClassInfo.of(inner.getDeclaringClass()).getConstructor(inner);
    }

    protected ConstructorInfo(ClassInfo declaringClass, Constructor<?> inner) {
        super(declaringClass, inner);
        this.inner = inner;
    }

    @Override
    public ConstructorInfo accessible() {
        super.accessible();
        return this;
    }

    @Override
    public int compareTo(ConstructorInfo o) {
        int i = Utils.cmp(this.getSimpleName(), o.getSimpleName());
        if (i == 0 && (i = this.getParameterCount() - o.getParameterCount()) == 0) {
            List<ParameterInfo> params = this.getParameters();
            List<ParameterInfo> oParams = o.getParameters();
            for (int j = 0; j < params.size() && i == 0; ++j) {
                i = Utils.cmp(params.get(j).getParameterType().getName(), oParams.get(j).getParameterType().getName());
            }
        }
        return i;
    }

    @Override
    public AnnotatableType getAnnotatableType() {
        return AnnotatableType.CONSTRUCTOR_TYPE;
    }

    @Override
    public String getLabel() {
        return this.getDeclaringClass().getNameSimple() + "." + this.getShortName();
    }

    public <T> Constructor<T> inner() {
        return this.inner;
    }

    public boolean equals(Object obj) {
        ConstructorInfo other;
        return obj instanceof ConstructorInfo && Utils.eq(this, other = (ConstructorInfo)obj, (x, y) -> Utils.eq(x.inner, y.inner));
    }

    public int hashCode() {
        return this.inner.hashCode();
    }

    public <T> T newInstance(Object ... args) throws ExecutableException {
        return (T)Utils.safe(() -> {
            try {
                return this.inner.newInstance(args);
            }
            catch (InvocationTargetException e) {
                throw ThrowableUtils.exex(e.getTargetException());
            }
        }, e -> ThrowableUtils.exex(e));
    }

    public <T> T newInstanceLenient(Object ... args) throws ExecutableException {
        return this.newInstance(ClassUtils.getMatchingArgs(this.inner.getParameterTypes(), args));
    }
}

