/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

class NestedTokenizer {
    NestedTokenizer() {
    }

    public static List<Token> tokenize(String in) {
        if (in == null) {
            throw ThrowableUtils.illegalArg((String)"Input was null.", (Object[])new Object[0]);
        }
        if (in.isBlank()) {
            throw ThrowableUtils.illegalArg((String)"Input was empty.", (Object[])new Object[0]);
        }
        int length = in.length();
        ParseState state = ParseState.PARSING_VALUE;
        StringBuilder currentValue = new StringBuilder();
        int nestedDepth = 0;
        int nestedStart = -1;
        ArrayList<Token> tokens = new ArrayList<Token>();
        boolean lastWasComma = false;
        boolean justCompletedNested = false;
        for (int pos = 0; pos < length; ++pos) {
            String value;
            char c = in.charAt(pos);
            if (state == ParseState.PARSING_VALUE) {
                if (c == '\\') {
                    state = ParseState.IN_ESCAPE;
                    continue;
                }
                if (c == ',') {
                    value = currentValue.toString().trim();
                    if (!value.isEmpty() || tokens.isEmpty() || !justCompletedNested) {
                        tokens.add(new Token(value));
                    }
                    currentValue.setLength(0);
                    nestedStart = -1;
                    lastWasComma = true;
                    justCompletedNested = false;
                    pos = NestedTokenizer.skipWhitespace(in, pos);
                    continue;
                }
                if (c == '{') {
                    nestedStart = pos + 1;
                    nestedDepth = 1;
                    state = ParseState.PARSING_NESTED;
                    continue;
                }
                currentValue.append(c);
                lastWasComma = false;
                justCompletedNested = false;
                continue;
            }
            if (state == ParseState.PARSING_NESTED) {
                if (c == '\\') {
                    state = ParseState.IN_ESCAPE;
                    continue;
                }
                if (c == '{') {
                    ++nestedDepth;
                    continue;
                }
                if (c != '}' || --nestedDepth != 0) continue;
                value = currentValue.toString().trim();
                String nestedContent = in.substring(nestedStart, pos);
                Token token = new Token(value);
                if (Utils.nb((String)nestedContent)) {
                    token.setNested(NestedTokenizer.tokenize(nestedContent));
                }
                tokens.add(token);
                currentValue.setLength(0);
                nestedStart = -1;
                lastWasComma = false;
                justCompletedNested = true;
                pos = NestedTokenizer.skipWhitespace(in, pos);
                state = ParseState.PARSING_VALUE;
                continue;
            }
            if (nestedDepth == 0) {
                currentValue.append(c);
            }
            state = nestedDepth > 0 ? ParseState.PARSING_NESTED : ParseState.PARSING_VALUE;
        }
        String finalValue = currentValue.toString().trim();
        if (!finalValue.isEmpty() || lastWasComma || tokens.isEmpty()) {
            tokens.add(new Token(finalValue));
        }
        return tokens;
    }

    private static int skipWhitespace(String input, int position) {
        int length = input.length();
        while (position + 1 < length && Character.isWhitespace(input.charAt(position + 1))) {
            ++position;
        }
        return position;
    }

    static enum ParseState {
        PARSING_VALUE,
        PARSING_NESTED,
        IN_ESCAPE;

    }

    public static class Token {
        private final String value;
        private List<Token> nested;

        public Token(String value) {
            this.value = (String)Utils.def((Object)value, (Object)"");
        }

        public boolean equals(Object o) {
            Token o2;
            return o instanceof Token && Utils.eq((Object)this, (Object)(o2 = (Token)o), (x, y) -> Utils.eq((Object)x.value, (Object)y.value) && Utils.eq(x.nested, y.nested));
        }

        public List<Token> getNested() {
            return Utils.nn(this.nested) ? Collections.unmodifiableList(this.nested) : Collections.emptyList();
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.nested);
        }

        public boolean hasNested() {
            return Utils.nn(this.nested) && !this.nested.isEmpty();
        }

        public String toString() {
            return this.hasNested() ? this.nested.stream().map(Object::toString).collect(Collectors.joining(",", this.value + "{", "}")) : this.value;
        }

        void setNested(List<Token> nested) {
            this.nested = nested;
        }
    }
}

