/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.util.List;
import java.util.Optional;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class DefaultClassList {
    private final List<Class<?>> entries;

    public static DefaultClassList create() {
        return new DefaultClassList();
    }

    public static DefaultClassList of(Class<?> ... values) {
        return new DefaultClassList().add(values);
    }

    public DefaultClassList(DefaultClassList value) {
        this.entries = CollectionUtils.copyOf(value.entries);
    }

    protected DefaultClassList() {
        this.entries = CollectionUtils.list((Object[])new Class[0]);
    }

    public DefaultClassList add(Class<?> ... values) {
        CollectionUtils.prependAll(this.entries, (Object[])values);
        return this;
    }

    public DefaultClassList copy() {
        return new DefaultClassList(this);
    }

    public <T> Optional<Class<? extends T>> get(Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"type", type);
        for (Class<?> e : this.entries) {
            if (!Utils.nn(e) || !type.isAssignableFrom(e)) continue;
            return Utils.opt(e);
        }
        return Utils.opte();
    }
}

