/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.event.WebsocketEvent;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.WebsocketSessionClusterSerializedRestore;
import org.apache.myfaces.push.cdi.WebsocketSessionManager;
import org.apache.myfaces.util.lang.Lazy;

public class EndpointImpl
extends Endpoint {
    public static final String JAKARTA_FACES_PUSH_PATH = "/jakarta.faces.push/{channel}";
    public static final String PUSH_CHANNEL_PARAMETER = "channel";
    private static final Logger LOG = Logger.getLogger(EndpointImpl.class.getName());
    private Lazy<BeanManager> beanManager = new Lazy<BeanManager>(() -> CDI.current().getBeanManager());

    public void onOpen(Session session, EndpointConfig config) {
        String channel = (String)session.getPathParameters().get(PUSH_CHANNEL_PARAMETER);
        String channelToken = session.getQueryString();
        WebsocketSessionManager sessionManager = CDIUtils.get(this.beanManager.get(), WebsocketSessionManager.class);
        if (Boolean.TRUE.equals(config.getUserProperties().get("oam.websocket.valid")) && sessionManager.addOrUpdateSession(channelToken, session)) {
            session.setMaxIdleTimeout(((Long)((Object)config.getUserProperties().getOrDefault("oam.websocket.maxIdleTimeout", 0))).longValue());
            Serializable user = (Serializable)session.getUserProperties().get("oam.websocket.user");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "EndPointImpl.onOpen (channel = {0}, token = {1}, user = {2})", new Object[]{channel, channelToken, user});
            }
            if (user != null) {
                sessionManager.registerUser(user, channel, channelToken);
            }
            this.beanManager.get().getEvent().select(new Annotation[]{WebsocketEvent.Opened.Literal.INSTANCE}).fire((Object)new WebsocketEvent(channel, user, null));
            session.getUserProperties().put("oam.websocket.SR", new WebsocketSessionClusterSerializedRestore(channelToken));
        } else {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Websocket connection not registered in current session"));
            }
            catch (IOException ex) {
                this.onError(session, ex);
            }
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        String channel = (String)session.getPathParameters().get(PUSH_CHANNEL_PARAMETER);
        String channelToken = session.getQueryString();
        Serializable user = (Serializable)session.getUserProperties().get("oam.websocket.user");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "EndPointImpl.onClose (channel = {0}, token = {1}, user = {2})", new Object[]{channel, channelToken, user});
        }
        if (!this.beanManager.isInitialized()) {
            try {
                this.beanManager.get();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not lazy initialize BeanManager on Endpoint#close, skip deregister session...", e);
                return;
            }
        }
        WebsocketSessionManager sessionManager = CDIUtils.get(this.beanManager.get(), WebsocketSessionManager.class);
        sessionManager.removeSession(channelToken, session);
        if (user != null) {
            sessionManager.deregisterUser(user, channel, channelToken);
        }
        this.beanManager.get().getEvent().select(new Annotation[]{WebsocketEvent.Closed.Literal.INSTANCE}).fire((Object)new WebsocketEvent(channel, user, closeReason.getCloseCode()));
    }

    public void onError(Session session, Throwable ex) {
        if (session.isOpen()) {
            session.getUserProperties().put(Throwable.class.getName(), ex);
        }
    }
}

