/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsResponse;

public class ListDirectoryBucketsPublisher
implements SdkPublisher<ListDirectoryBucketsResponse> {
    private final S3AsyncClient client;
    private final ListDirectoryBucketsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDirectoryBucketsPublisher(S3AsyncClient client, ListDirectoryBucketsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDirectoryBucketsPublisher(S3AsyncClient client, ListDirectoryBucketsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDirectoryBucketsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDirectoryBucketsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Bucket> buckets() {
        return this.flatMapIterable(response -> response.buckets());
    }

    private class ListDirectoryBucketsResponseFetcher
    implements AsyncPageFetcher<ListDirectoryBucketsResponse> {
        private ListDirectoryBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListDirectoryBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.continuationToken());
        }

        public CompletableFuture<ListDirectoryBucketsResponse> nextPage(ListDirectoryBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListDirectoryBucketsPublisher.this.client.listDirectoryBuckets(ListDirectoryBucketsPublisher.this.firstRequest);
            }
            return ListDirectoryBucketsPublisher.this.client.listDirectoryBuckets((ListDirectoryBucketsRequest)((Object)ListDirectoryBucketsPublisher.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build()));
        }
    }
}

