/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import org.springframework.security.authorization.AllAuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.SingleResultAuthorizationManager;

public interface AuthorizationManagerFactory<T> {
    default public AuthorizationManager<T> permitAll() {
        return SingleResultAuthorizationManager.permitAll();
    }

    default public AuthorizationManager<T> denyAll() {
        return SingleResultAuthorizationManager.denyAll();
    }

    default public AuthorizationManager<T> hasRole(String role) {
        return AuthorityAuthorizationManager.hasRole(role);
    }

    default public AuthorizationManager<T> hasAnyRole(String ... roles) {
        return AuthorityAuthorizationManager.hasAnyRole(roles);
    }

    default public AuthorizationManager<T> hasAllRoles(String ... roles) {
        return AllAuthoritiesAuthorizationManager.hasAllRoles(roles);
    }

    default public AuthorizationManager<T> hasAuthority(String authority) {
        return AuthorityAuthorizationManager.hasAuthority(authority);
    }

    default public AuthorizationManager<T> hasAnyAuthority(String ... authorities) {
        return AuthorityAuthorizationManager.hasAnyAuthority(authorities);
    }

    default public AuthorizationManager<T> hasAllAuthorities(String ... authorities) {
        return AllAuthoritiesAuthorizationManager.hasAllAuthorities(authorities);
    }

    default public AuthorizationManager<T> authenticated() {
        return AuthenticatedAuthorizationManager.authenticated();
    }

    default public AuthorizationManager<T> fullyAuthenticated() {
        return AuthenticatedAuthorizationManager.fullyAuthenticated();
    }

    default public AuthorizationManager<T> rememberMe() {
        return AuthenticatedAuthorizationManager.rememberMe();
    }

    default public AuthorizationManager<T> anonymous() {
        return AuthenticatedAuthorizationManager.anonymous();
    }
}

