/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public final class SingleResultAuthorizationManager<C>
implements AuthorizationManager<C> {
    private static final SingleResultAuthorizationManager<?> DENY_MANAGER = new SingleResultAuthorizationManager(new AuthorizationDecision(false));
    private static final SingleResultAuthorizationManager<?> PERMIT_MANAGER = new SingleResultAuthorizationManager(new AuthorizationDecision(true));
    private final AuthorizationResult result;

    public SingleResultAuthorizationManager(AuthorizationResult result) {
        Assert.notNull((Object)result, (String)"result cannot be null");
        this.result = result;
    }

    @Override
    public AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> authentication, C object) {
        if (!(this.result instanceof AuthorizationDecision)) {
            throw new IllegalArgumentException("result should be AuthorizationDecision");
        }
        return this.result;
    }

    public static <C> SingleResultAuthorizationManager<C> denyAll() {
        return DENY_MANAGER;
    }

    public static <C> SingleResultAuthorizationManager<C> permitAll() {
        return PERMIT_MANAGER;
    }
}

