/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal.shared;

import java.time.Instant;
import java.util.AbstractList;
import org.apache.sis.math.Vector;
import org.apache.sis.util.collection.CheckedContainer;

final class InstantList
extends AbstractList<Instant>
implements CheckedContainer<Instant> {
    private final Vector times;

    InstantList(Vector times) {
        this.times = times;
    }

    static Vector vectorize(long[] millis) {
        return Vector.create((Object)millis, (boolean)false).compress(0.0);
    }

    public Class<Instant> getElementType() {
        return Instant.class;
    }

    public final CheckedContainer.Mutability getMutability() {
        return CheckedContainer.Mutability.IMMUTABLE;
    }

    @Override
    public int size() {
        return this.times.size();
    }

    @Override
    public Instant get(int index) {
        return Instant.ofEpochMilli(this.times.longValue(index));
    }
}

