/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.collection.CodeListSet;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Processing;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class MetadataFetcher {
    private static final DateType[] LAST_UPDATE_TYPES = new DateType[]{DateType.valueOf((String)"LAST_UPDATE"), DateType.valueOf((String)"LAST_REVISION"), DateType.REVISION, DateType.valueOf((String)"IN_FORCE"), DateType.valueOf((String)"RELEASED"), DateType.valueOf((String)"DISTRIBUTION"), DateType.PUBLICATION, DateType.valueOf((String)"ADOPTED"), DateType.CREATION};
    public List<String> title;
    public List<String> series;
    public List<String> page;
    public List<String> party;
    public List<Temporal> creationDate;
    public List<Temporal> lastUpdate;
    private int lastUpdateType;
    public List<String> instrument;
    public List<String> software;
    public List<String> procedure;
    public List<String> transformationDimension;
    public Set<CellGeometry> cellGeometry;
    protected final Locale locale;

    public MetadataFetcher(Locale locale) {
        this.locale = locale;
        this.lastUpdateType = LAST_UPDATE_TYPES.length;
    }

    private <E> void forEach(BiPredicate<MetadataFetcher, E> accept, Iterable<? extends E> elements) {
        block1: {
            if (elements == null) break block1;
            for (E info : elements) {
                if (info != null && accept.test(this, info)) break;
            }
        }
    }

    public void accept(Metadata info) {
        if (info != null) {
            this.forEach(MetadataFetcher::accept, info.getIdentificationInfo());
            this.forEach(MetadataFetcher::accept, info.getAcquisitionInformation());
            this.forEach(MetadataFetcher::accept, info.getSpatialRepresentationInfo());
            if (info instanceof DefaultMetadata) {
                this.forEach(MetadataFetcher::accept, ((DefaultMetadata)info).getResourceLineages());
            }
        }
    }

    protected boolean accept(Identification info) {
        Citation citation = info.getCitation();
        if (citation == null) {
            return false;
        }
        this.title = this.addString(this.title, citation.getTitle());
        Series e = citation.getSeries();
        if (e != null) {
            this.series = this.addString(this.series, e.getName());
            this.page = MetadataFetcher.addString(this.page, e.getPage());
        }
        this.forEach(MetadataFetcher::accept, citation.getCitedResponsibleParties());
        this.forEach(MetadataFetcher::accept, citation.getDates());
        return this.title != null;
    }

    protected boolean accept(ResponsibleParty info) {
        this.party = MetadataFetcher.addString(this.party, info.getIndividualName());
        this.party = this.addString(this.party, info.getOrganisationName());
        return false;
    }

    protected boolean accept(CitationDate info) {
        DateType type = info.getDateType();
        if (type == DateType.CREATION) {
            this.creationDate = this.addDate(this.creationDate, info, false);
        }
        int limit = LAST_UPDATE_TYPES.length - 1;
        int i = Math.min(this.lastUpdateType, limit);
        do {
            if (!LAST_UPDATE_TYPES[i].equals((Object)type)) continue;
            this.lastUpdate = this.addDate(this.lastUpdate, info, i < limit);
            this.lastUpdateType = i;
            break;
        } while (--i >= 0);
        return false;
    }

    protected boolean accept(Lineage info) {
        this.forEach(MetadataFetcher::accept, info.getProcessSteps());
        return false;
    }

    protected boolean accept(ProcessStep info) {
        Processing processing = info.getProcessingInformation();
        if (processing != null) {
            this.software = this.addStrings(this.software, processing.getSoftwareReferences(), Citation::getTitle);
            this.procedure = this.addString(this.procedure, processing.getProcedureDescription());
        }
        return false;
    }

    protected boolean accept(AcquisitionInformation info) {
        this.forEach(MetadataFetcher::accept, info.getPlatforms());
        return false;
    }

    protected boolean accept(Platform info) {
        this.forEach(MetadataFetcher::accept, info.getInstruments());
        return false;
    }

    protected boolean accept(Instrument info) {
        Identifier id = info.getIdentifier();
        if (id != null) {
            this.instrument = MetadataFetcher.addString(this.instrument, id.getCode());
        }
        return false;
    }

    protected boolean accept(SpatialRepresentation info) {
        if (info instanceof GridSpatialRepresentation) {
            MetadataFetcher.addCode(CellGeometry.class, this.cellGeometry, ((GridSpatialRepresentation)info).getCellGeometry());
            if (info instanceof Georectified) {
                this.addString(this.transformationDimension, ((Georectified)info).getTransformationDimensionDescription());
            }
        }
        return false;
    }

    private <E> List<String> addStrings(List<String> target, Iterable<? extends E> source, Function<E, InternationalString> getter) {
        if (source != null) {
            for (E e : source) {
                if (e == null) continue;
                target = this.addString(target, getter.apply(e));
            }
        }
        return target;
    }

    private List<String> addString(List<String> target, InternationalString value) {
        if (value != null) {
            target = MetadataFetcher.addString(target, value.toString(this.locale));
        }
        return target;
    }

    private static List<String> addString(List<String> target, String value) {
        if (value != null && !(value = value.trim()).isBlank()) {
            if (target == null) {
                target = new ArrayList<String>(2);
            }
            target.add(value);
        }
        return target;
    }

    private static <E extends CodeList<E>> Set<E> addCode(Class<E> type, Set<E> target, E value) {
        if (value != null) {
            if (target == null) {
                target = new CodeListSet(type);
            }
            target.add(value);
        }
        return target;
    }

    private List<Temporal> addDate(List<Temporal> target, CitationDate value, boolean clear) {
        Date date = value.getDate();
        if (date != null) {
            if (target == null) {
                target = new ArrayList<Temporal>(2);
            } else if (clear) {
                target.clear();
            }
            target.add(TemporalDate.toTemporal((Date)date));
        }
        return target;
    }

    public static Instant lastUpdate(Metadata metadata, ZoneId zone, StoreListeners listeners) {
        Temporal lastUpdate = null;
        if (metadata != null) {
            int lastUpdateType = LAST_UPDATE_TYPES.length;
            block2: for (Identification info : metadata.getIdentificationInfo()) {
                Citation citation = info.getCitation();
                if (citation == null) continue;
                for (CitationDate date : citation.getDates()) {
                    DateType type = date.getDateType();
                    int i = lastUpdateType;
                    while (--i >= 0) {
                        if (!LAST_UPDATE_TYPES[i].equals((Object)type)) continue;
                        lastUpdateType = i;
                        lastUpdate = TemporalDate.toTemporal((Date)date.getDate());
                        if (i != 0) continue;
                        break block2;
                    }
                }
            }
        }
        try {
            return TemporalDate.toInstant(lastUpdate, (ZoneId)zone);
        }
        catch (DateTimeException e) {
            if (listeners == null) {
                throw e;
            }
            listeners.warning(e);
            return null;
        }
    }
}

