/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl.common;

import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.resources.impl.common.SimpleReadableResource;

public class SimpleReadableResourceIterator
implements Iterator<Resource> {
    private final Iterator<Map<String, Object>> itemsIterator;
    private final ResourceResolver resourceResolver;
    private final String parentPath;

    SimpleReadableResourceIterator(Iterator<Map<String, Object>> itemsIterator, ResourceResolver resourceResolver, String parentPath) {
        this.itemsIterator = itemsIterator;
        this.resourceResolver = resourceResolver;
        this.parentPath = parentPath;
    }

    @Override
    public boolean hasNext() {
        return this.itemsIterator.hasNext();
    }

    @Override
    public Resource next() {
        Map<String, Object> itemProperties = this.itemsIterator.next();
        String itemName = (String)itemProperties.remove("internal:adaptable");
        String resourcePath = this.parentPath + "/" + itemName;
        return new SimpleReadableResource(this.resourceResolver, resourcePath, itemProperties, new Object[0]);
    }

    @Override
    public void remove() {
        this.itemsIterator.remove();
    }
}

