/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellSubmission {
    private static final Logger LOG = LoggerFactory.getLogger(ShellSubmission.class);

    public static void main(String[] args) throws Exception {
        if (args.length <= 1) {
            LOG.error("Arguments should be of the form: <path_to_jar> [argument...]");
            System.exit(-1);
        }
        Map conf = ConfigUtils.readStormConfig();
        try (NimbusClient client = NimbusClient.Builder.withConf((Map)conf).build();){
            NimbusSummary ns = client.getClient().getLeader();
            String host = ns.get_host();
            int port = ns.get_port();
            String jarPath = StormSubmitter.submitJar((Map)conf, (String)args[0]);
            String[] newArgs = (String[])ArrayUtils.addAll((Object[])Arrays.copyOfRange(args, 1, args.length), (Object[])new String[]{host, String.valueOf(port), jarPath});
            ServerUtils.execCommand((String[])newArgs);
        }
    }
}

