/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core.cli;

import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.Cli;
import io.dropwizard.core.cli.ConfiguredCommand;
import io.dropwizard.core.setup.Bootstrap;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckCommand.class);
    private final Class<T> configurationClass;

    public CheckCommand(Application<T> application) {
        super("check", "Parses and validates the configuration file");
        this.configurationClass = application.getConfigurationClass();
    }

    @Override
    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    @Override
    protected void run(Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
        LOGGER.info("Configuration is OK");
    }

    @Override
    public void onError(Cli cli, Namespace namespace, Throwable e) {
        cli.getStdErr().println(e.getMessage());
    }
}

