/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.io;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.compiler.io.RuntimeIOException;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CIndenter {
    private static final String INDENT = "  ";
    private static final String HALF_INDENT = " ";
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\n");
    private final Appendable out;
    private final List<String> halfIndentMarkers;
    private int indentationLevel = 0;

    public CIndenter(Appendable out, String ... halfIndentMarkers) {
        this.out = Preconditions.checkNotNull(out);
        this.halfIndentMarkers = ImmutableList.of(halfIndentMarkers);
    }

    private void appendIndent(boolean oneLessSpace) throws IOException {
        for (int i = 0; i < this.indentationLevel; ++i) {
            this.out.append(oneLessSpace && i == this.indentationLevel - 1 ? HALF_INDENT : INDENT);
        }
    }

    private void appendTailComment(int lineLength, String tailComment) throws IOException {
        if (tailComment.length() > 0) {
            int indentLength = this.indentationLevel * INDENT.length();
            int spacerLength = Math.max(80 - (lineLength + indentLength), 3);
            for (int i = 0; i < spacerLength; ++i) {
                this.out.append(HALF_INDENT);
            }
            this.out.append(tailComment);
        }
    }

    public void addIndent() {
        ++this.indentationLevel;
    }

    public void appendLine(CharSequence line) {
        this.appendLine(line, "");
    }

    public void appendLine(CharSequence line, String tailComment) {
        try {
            if (line.length() == 0) {
                if (tailComment.length() > 0) {
                    this.appendIndent(false);
                    this.appendTailComment(0, tailComment);
                }
                this.out.append("\n");
            } else {
                CharSequence cs;
                if (line.charAt(0) == '}') {
                    --this.indentationLevel;
                }
                this.appendIndent(this.halfIndentMarkers.contains(line));
                Matcher m = NEWLINE_PATTERN.matcher(line);
                int sliceStart = 0;
                while (m.find()) {
                    cs = line.subSequence(sliceStart, m.start());
                    this.out.append(cs);
                    this.appendTailComment(cs.length(), tailComment);
                    this.out.append("\n");
                    this.appendIndent(this.halfIndentMarkers.contains(line));
                    sliceStart = m.end();
                }
                cs = line.subSequence(sliceStart, line.length());
                this.out.append(cs);
                this.appendTailComment(cs.length(), tailComment);
                this.out.append("\n");
                if (line.charAt(line.length() - 1) == '{') {
                    ++this.indentationLevel;
                }
            }
        }
        catch (IOException iox) {
            throw new RuntimeIOException(iox);
        }
    }
}

