/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.math.BigInteger;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class BigIntegerSerializer
implements ObjectSerializer<BigInteger> {
    @Override
    public int typeValue() {
        return 25;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.OBJECT;
    }

    @Override
    public boolean defaultStoreReference() {
        return true;
    }

    @Override
    public void write(BigInteger value, VirtualizationOutput out) throws IOException {
        byte[] integerBytes = value.toByteArray();
        out.writeIntCompressed(integerBytes.length);
        out.write(integerBytes);
    }

    @Override
    public BigInteger read(VirtualizationInput in) throws IOException {
        int byteCount = in.readIntCompressed();
        byte[] bytes = new byte[byteCount];
        in.readFully(bytes);
        return new BigInteger(bytes);
    }
}

