/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.search;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;
import java.util.ArrayList;
import java.util.List;

public class CompositeSearchKeywordResolver
extends SearchKeywordResolver {
    private static final int NUMBER_OF_DEFAULT_IMPLEMENTATIONS = 12;
    private final List<SearchKeywordResolver> resolvers = new ArrayList<SearchKeywordResolver>(12);

    public void add(SearchKeywordResolver searchKeywordResolver) {
        if (searchKeywordResolver == null) {
            throw new NullPointerException();
        }
        this.resolvers.add(0, searchKeywordResolver);
    }

    @Override
    public void resolve(SearchKeywordContext context, UIComponent current, String keyword) {
        context.setKeywordResolved(false);
        for (int i = 0; i < this.resolvers.size(); ++i) {
            SearchKeywordResolver resolver = this.resolvers.get(i);
            if (!resolver.isResolverForKeyword(context.getSearchExpressionContext(), keyword)) continue;
            resolver.resolve(context, current, keyword);
            if (!context.isKeywordResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            SearchKeywordResolver resolver = this.resolvers.get(i);
            if (!resolver.isResolverForKeyword(searchExpressionContext, keyword)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            SearchKeywordResolver resolver = this.resolvers.get(i);
            if (!resolver.isResolverForKeyword(searchExpressionContext, keyword)) continue;
            return resolver.isPassthrough(searchExpressionContext, keyword);
        }
        return false;
    }

    @Override
    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            SearchKeywordResolver resolver = this.resolvers.get(i);
            if (!resolver.isResolverForKeyword(searchExpressionContext, keyword)) continue;
            return resolver.isLeaf(searchExpressionContext, keyword);
        }
        return false;
    }
}

