/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.jdiskreport.domain.ScanConfiguration;
import com.jgoodies.jdiskreport.domain.ScanResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class PersistencyManager {
    private PersistencyManager() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ScanConfiguration readScanConfiguration(File inputFile) {
        Preconditions.checkNotNull(inputFile, "The %s must not be null.", "input file");
        try (FileInputStream in = new FileInputStream(inputFile);){
            Properties properties = new Properties();
            properties.load(in);
            ScanConfiguration scanConfiguration = ScanConfiguration.from(properties);
            return scanConfiguration;
        }
        catch (FileNotFoundException ex) {
            System.err.println("The input file does not exists, or is a directory rather than a regular file, or cannot be opened for any other reason.");
            ex.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("Failed to read the scan configuration from file: " + inputFile);
            return null;
        }
    }

    public static void writeScanConfiguration(File outputFile, ScanConfiguration configuration) {
        Preconditions.checkNotNull(outputFile, "The %s must not be null.", "output file");
        Preconditions.checkNotNull(configuration, "The %s must not be null.", "scan configuration");
        Properties properties = configuration.asProperties();
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            properties.store(out, "JDiskReport2 scan configuration properties");
        }
        catch (FileNotFoundException ex) {
            System.err.println("The output file exists but is a directory rather than a regular file, does not exist but cannot be created, or cannot be opened for any other reason.");
            ex.printStackTrace();
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("Failed to write the scan configuration to file: " + outputFile);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static ScanResult readScanResult(File inputFile) {
        Preconditions.checkNotNull(inputFile, "The %s must not be null.", "input file");
        if (!inputFile.exists()) {
            System.err.format("The input file %s does not exist.\n", inputFile);
            return null;
        }
        if (!inputFile.isFile()) {
            System.err.format("The input file %s does not exist.\n", inputFile);
            return null;
        }
        try {
            Throwable throwable = null;
            try (ZipFile zipFile = new ZipFile(inputFile, 1);){
                ScanResult scanResult;
                Throwable throwable2;
                ObjectInputStream objectIn;
                block45: {
                    block46: {
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        if (!entries.hasMoreElements()) {
                            System.err.println("Missing report file zip entry.");
                            ScanResult scanResult2 = null;
                            return scanResult2;
                        }
                        ZipEntry entry = entries.nextElement();
                        if (entries.hasMoreElements()) {
                            System.err.println("Warning: a report file should contain a single zip entry only.");
                        }
                        InputStream in = zipFile.getInputStream(entry);
                        objectIn = new ObjectInputStream(in);
                        throwable2 = null;
                        scanResult = (ScanResult)objectIn.readObject();
                        if (objectIn == null) break block45;
                        if (throwable2 == null) break block46;
                        try {
                            objectIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block45;
                    }
                    objectIn.close();
                }
                return scanResult;
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (objectIn != null) {
                                if (throwable2 != null) {
                                    try {
                                        objectIn.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                } else {
                                    objectIn.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (IOException ex) {
                        System.err.format("The input file %s cannot be read.\n", inputFile);
                        ex.printStackTrace();
                        throwable2 = null;
                        if (zipFile != null) {
                            if (throwable != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                zipFile.close();
                            }
                        }
                        return throwable2;
                    }
                    catch (ClassNotFoundException ex) {
                        block47: {
                            block48: {
                                System.err.format("The input file %s cannot be opened.\nLikely the JDiskReport version used to save the file is incompatible with the version you use to read the file.", inputFile);
                                ex.printStackTrace();
                                throwable2 = null;
                                if (zipFile == null) break block47;
                                if (throwable == null) break block48;
                                try {
                                    zipFile.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                                break block47;
                            }
                            zipFile.close();
                        }
                        return throwable2;
                        catch (Throwable throwable9) {
                            throwable = throwable9;
                            throw throwable9;
                        }
                        catch (Throwable throwable10) {
                            throw throwable10;
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            System.err.format("The input file %s cannot be opened.\n", inputFile);
            ex.printStackTrace();
            return null;
        }
    }

    public static void writeScanResult(File outputFile, ScanResult result) {
        Preconditions.checkNotNull(outputFile, "The %s must not be null.", "output file");
        Preconditions.checkNotNull(result, "The %s must not be null.", "scan result");
        ZipEntry zipEntry = new ZipEntry(outputFile.getName() + ".uncompressed");
        try (FileOutputStream out = new FileOutputStream(outputFile);
             ZipOutputStream zipOut = new ZipOutputStream(out);){
            zipOut.putNextEntry(zipEntry);
            try (ObjectOutputStream objectOut = new ObjectOutputStream(zipOut);){
                objectOut.writeObject(result);
                zipOut.closeEntry();
            }
            catch (IOException ioex) {
                System.err.println("Failed to write a scan result to the compressed output file: " + outputFile.getName());
                ioex.printStackTrace();
                if (zipOut != null) {
                    if (var6_10 != null) {
                        try {
                            zipOut.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        zipOut.close();
                    }
                }
                if (out != null) {
                    if (var4_6 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
                return;
            }
            System.out.format("Scan result for '%1$s' written to '%2$s'.", result.getConfiguration().getName(), outputFile);
        }
        catch (FileNotFoundException ex) {
            System.err.format("The output file %sexists but is a directory rather than a regular file, does not exist but cannot be created, or cannot be opened for any other reason.\n", outputFile);
            ex.printStackTrace();
            return;
        }
        catch (IOException ex) {
            System.err.println("Failed to write a scan result to file: " + outputFile.getName());
            ex.printStackTrace();
        }
    }
}

