/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;

public class PDFResourceContext
extends PDFDictionary {
    private Set<PDFXObject> xObjects = new LinkedHashSet<PDFXObject>();
    private Set<PDFPattern> patterns = new LinkedHashSet<PDFPattern>();
    private Set<PDFShading> shadings = new LinkedHashSet<PDFShading>();
    private Set<PDFGState> gstates = new LinkedHashSet<PDFGState>();

    public PDFResourceContext(PDFResources resources) {
        this.put("Resources", resources);
        resources.addContext(this);
    }

    public void addXObject(PDFXObject xObject) {
        this.xObjects.add(xObject);
    }

    public Set<PDFXObject> getXObjects() {
        return this.xObjects;
    }

    public PDFResources getPDFResources() {
        return (PDFResources)this.get("Resources");
    }

    public void addAnnotation(PDFObject annot) {
        PDFAnnotList annotList = this.getAnnotations();
        if (annotList == null) {
            annotList = this.getDocument().getFactory().makeAnnotList();
            this.put("Annots", annotList);
        }
        annotList.addAnnot(annot);
    }

    public PDFAnnotList getAnnotations() {
        return (PDFAnnotList)this.get("Annots");
    }

    public void addGState(PDFGState gstate) {
        this.gstates.add(gstate);
    }

    public Set<PDFGState> getGStates() {
        return this.gstates;
    }

    public void addShading(PDFShading shading) {
        this.shadings.add(shading);
    }

    public Set<PDFShading> getShadings() {
        return this.shadings;
    }

    public Set<PDFPattern> getPatterns() {
        return this.patterns;
    }

    public void addPattern(PDFPattern pattern) {
        this.patterns.add(pattern);
    }
}

