/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Untar;
import org.netbeans.installer.infra.build.ant.utils.Utils;

public class NativeUntar
extends Untar {
    private File dest;
    private File source;

    public void setDest(File d) {
        this.dest = d;
        super.setDest(d);
    }

    public void setSrc(File s) {
        this.source = s;
        super.setSrc(s);
    }

    public void execute() throws BuildException {
        try {
            Utils.setProject(this.getProject());
            this.log("trying native untar");
            Utils.nativeUntar(this.source, this.dest);
        }
        catch (IOException e) {
            this.log("native untar failed, falling back to java implementation");
            Utils.delete(this.dest);
            Untar.UntarCompressionMethod compression = new Untar.UntarCompressionMethod();
            if (this.source.getName().endsWith(".tar.gz") || this.source.getName().endsWith(".tgz")) {
                compression.setValue("gzip");
            } else if (this.source.getName().endsWith(".tar.bz2") || this.source.getName().endsWith(".tar.bzip2")) {
                compression.setValue("bzip2");
            } else {
                compression.setValue("none");
            }
            this.setCompression(compression);
            super.execute();
        }
    }
}

