/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.io.OutputStream;
import java.text.ParseException;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OBRXMLWriter {
    public static ContentHandler newHandler(OutputStream out, String encoding, boolean indent) throws TransformerConfigurationException {
        TransformerHandler hd = XMLHelper.getTransformerHandler();
        hd.getTransformer().setOutputProperty("encoding", encoding);
        hd.getTransformer().setOutputProperty("indent", indent ? "yes" : "no");
        StreamResult stream = new StreamResult(out);
        hd.setResult(stream);
        return hd;
    }

    public static void writeManifests(Iterable<ManifestAndLocation> manifestAndLocations, ContentHandler handler, boolean quiet) throws SAXException {
        int level = quiet ? 4 : 1;
        handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "repository", "repository", atts);
        int nbOk = 0;
        int nbRejected = 0;
        for (ManifestAndLocation manifestAndLocation : manifestAndLocations) {
            BundleInfo bundleInfo;
            try {
                bundleInfo = ManifestParser.parseManifest(manifestAndLocation.getManifest());
                bundleInfo.addArtifact(new BundleArtifact(false, manifestAndLocation.getUri(), null));
                if (manifestAndLocation.getSourceURI() != null) {
                    bundleInfo.addArtifact(new BundleArtifact(true, manifestAndLocation.getSourceURI(), null));
                }
                ++nbOk;
            }
            catch (ParseException e) {
                ++nbRejected;
                IvyContext.getContext().getMessageLogger().log("Rejected " + manifestAndLocation.getUri() + ": " + e.getMessage(), level);
                continue;
            }
            OBRXMLWriter.saxBundleInfo(bundleInfo, handler);
        }
        handler.endElement("", "repository", "repository");
        handler.endDocument();
        Message.info(nbOk + " bundle" + (nbOk > 1 ? "s" : "") + " added, " + nbRejected + " bundle" + (nbRejected > 1 ? "s" : "") + " rejected.");
    }

    public static void writeBundles(Iterable<BundleInfo> bundleInfos, ContentHandler handler) throws SAXException {
        handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "repository", "repository", atts);
        for (BundleInfo bundleInfo : bundleInfos) {
            OBRXMLWriter.saxBundleInfo(bundleInfo, handler);
        }
        handler.endElement("", "repository", "repository");
        handler.endDocument();
    }

    private static void saxBundleInfo(BundleInfo bundleInfo, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        OBRXMLWriter.addAttr(atts, "symbolicname", bundleInfo.getSymbolicName());
        OBRXMLWriter.addAttr(atts, "version", bundleInfo.getRawVersion());
        for (BundleArtifact artifact : bundleInfo.getArtifacts()) {
            if (artifact.isSource()) continue;
            OBRXMLWriter.addAttr(atts, "uri", bundleInfo.getArtifacts().get(0).getUri().toString());
            break;
        }
        handler.startElement("", "resource", "resource", atts);
        for (BundleArtifact artifact : bundleInfo.getArtifacts()) {
            if (!artifact.isSource()) continue;
            OBRXMLWriter.startElement(handler, "source");
            OBRXMLWriter.characters(handler, artifact.getUri().toString());
            OBRXMLWriter.endElement(handler, "source");
            break;
        }
        for (BundleCapability capability : bundleInfo.getCapabilities()) {
            OBRXMLWriter.saxCapability(capability, handler);
        }
        for (BundleRequirement requirement : bundleInfo.getRequirements()) {
            OBRXMLWriter.saxRequirement(requirement, handler);
        }
        handler.endElement("", "resource", "resource");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxCapability(BundleCapability capability, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String type = capability.getType();
        OBRXMLWriter.addAttr(atts, "name", type);
        handler.startElement("", "capability", "capability", atts);
        switch (type) {
            case "bundle": {
                break;
            }
            case "package": {
                Set<String> uses;
                OBRXMLWriter.saxCapabilityProperty("package", capability.getName(), handler);
                Version v = capability.getRawVersion();
                if (v != null) {
                    OBRXMLWriter.saxCapabilityProperty("version", v.toString(), handler);
                }
                if ((uses = ((ExportPackage)capability).getUses()) == null || uses.isEmpty()) break;
                StringBuilder builder = new StringBuilder();
                for (String use : uses) {
                    if (builder.length() != 0) {
                        builder.append(',');
                    }
                    builder.append(use);
                }
                OBRXMLWriter.saxCapabilityProperty("uses", builder.toString(), handler);
                break;
            }
            case "service": {
                OBRXMLWriter.saxCapabilityProperty("service", capability.getName(), handler);
                Version v = capability.getRawVersion();
                if (v == null) break;
                OBRXMLWriter.saxCapabilityProperty("version", v.toString(), handler);
                break;
            }
        }
        handler.endElement("", "capability", "capability");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxCapabilityProperty(String n, String v, ContentHandler handler) throws SAXException {
        OBRXMLWriter.saxCapabilityProperty(n, null, v, handler);
    }

    private static void saxCapabilityProperty(String n, String t, String v, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        OBRXMLWriter.addAttr(atts, "n", n);
        if (t != null) {
            OBRXMLWriter.addAttr(atts, "t", t);
        }
        OBRXMLWriter.addAttr(atts, "v", v);
        handler.startElement("", "p", "p", atts);
        handler.endElement("", "p", "p");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxRequirement(BundleRequirement requirement, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        OBRXMLWriter.addAttr(atts, "name", requirement.getType());
        if ("optional".equals(requirement.getResolution())) {
            OBRXMLWriter.addAttr(atts, "optional", Boolean.TRUE.toString());
        }
        OBRXMLWriter.addAttr(atts, "filter", OBRXMLWriter.buildFilter(requirement));
        handler.startElement("", "require", "require", atts);
        handler.endElement("", "require", "require");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static String buildFilter(BundleRequirement requirement) {
        StringBuilder filter = new StringBuilder();
        VersionRange v = requirement.getVersion();
        if (v != null) {
            OBRXMLWriter.appendVersion(filter, v);
        }
        filter.append('(');
        filter.append(requirement.getType());
        filter.append("=");
        filter.append(requirement.getName());
        filter.append(')');
        if (v != null) {
            filter.append(')');
        }
        return filter.toString();
    }

    private static void appendVersion(StringBuilder filter, VersionRange v) {
        Version end;
        filter.append("(&");
        Version start = v.getStartVersion();
        if (start != null) {
            if (!v.isStartExclusive()) {
                filter.append("(version>=");
                filter.append(start.toString());
                filter.append(')');
            } else {
                filter.append("(!");
                filter.append("(version<=");
                filter.append(start.toString());
                filter.append("))");
            }
        }
        if ((end = v.getEndVersion()) != null) {
            if (!v.isEndExclusive()) {
                filter.append("(version<=");
                filter.append(end.toString());
                filter.append(')');
            } else {
                filter.append("(!");
                filter.append("(version>=");
                filter.append(end.toString());
                filter.append("))");
            }
        }
    }

    private static void addAttr(AttributesImpl atts, String name, String value) {
        if (value != null) {
            atts.addAttribute("", name, name, "CDATA", value);
        }
    }

    private static void addAttr(AttributesImpl atts, String name, Object value) {
        if (value != null) {
            atts.addAttribute("", name, name, "CDATA", value.toString());
        }
    }

    private static void startElement(ContentHandler handler, String name) throws SAXException {
        handler.startElement("", name, name, new AttributesImpl());
    }

    private static void endElement(ContentHandler handler, String name) throws SAXException {
        handler.endElement("", name, name);
    }

    private static void characters(ContentHandler handler, String value) throws SAXException {
        char[] chars = value.toCharArray();
        handler.characters(chars, 0, chars.length);
    }
}

