<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Apache Beam Committer Onboarding Guide

A brief checklist of things to know and do for new committers.

## For you, the new committer

 - [ ] Sign an ICLA and send it to secretary@apache.org if you haven't before.
 - [ ] Read the ASF new committer guide:
       https://www.apache.org/dev/new-committers-guide.html
 - [ ] Read the [Beam committer guide](committer-guide.md)
 - [ ] Log in to https://whimsy.apache.org; that will confirm a working ASF account
       you can edit email routing for the account, and add other emails that
       you own you can directly edit mailing list subscriptions (for example,
       you might switch them to your ASF account - you can still post from any
       of your registered emails)\
 - [ ] Link your GitHub account with your ASF account at
       https://gitbox.apache.org/. Once you see the big green "Merge" button on pull
       requests, this is working.

## For the PMC

 - [ ] (PMC Chair) Add the new committer to https://whimsy.apache.org/roster/committee/beam
 - [ ] Announce the new committer
