/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React, {ReactElement} from 'react';

export function KaravanIcon(className?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            id="svg50"
            width={32}
            height={32}
            preserveAspectRatio="xMidYMid"
            version="1.1"
            viewBox="0 0 256 256"
            className={className ? className : "logo"}
        >
            <defs id="defs31">
                <linearGradient id="linearGradient1351">
                    <stop
                        id="stop1347"
                        offset="0"
                        stopColor="#dcffff"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop1349"
                        offset="1"
                        stopColor="#96d2e6"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <circle id="path-1" cx="128" cy="128" r="128"></circle>
                <linearGradient
                    id="linearGradient-3"
                    x1="-26.051"
                    x2="254.316"
                    y1="271.331"
                    y2="0.048"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop
                        id="stop10"
                        offset="0%"
                        stopColor="#4790bb"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop12"
                        offset="10.996%"
                        stopColor="#64b7db"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop14"
                        offset="94.502%"
                        stopColor="#326ea0"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-4"
                    x1="-32.163"
                    x2="259.338"
                    y1="277.029"
                    y2="-5.028"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop id="stop17" offset="0%" stopColor="#F69923"></stop>
                    <stop id="stop19" offset="8.048%" stopColor="#F79A23"></stop>
                    <stop id="stop21" offset="41.874%" stopColor="#E97826"></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-5"
                    x1="217.945"
                    x2="99.459"
                    y1="67.505"
                    y2="247.005"
                    gradientTransform="scale(.96442 1.0369)"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient-4"
                >
                    <stop
                        id="stop24"
                        offset="0%"
                        stopColor="#92d6d5"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop26"
                        offset="41.191%"
                        stopColor="#79b7cc"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop28"
                        offset="73.271%"
                        stopColor="#5891c5"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <mask id="mask-2" fill="#fff">
                    <use id="use33" xlinkHref="#path-1"></use>
                </mask>
                <mask id="mask-2-7" fill="#fff">
                    <use id="use137" xlinkHref="#path-1"></use>
                </mask>
                <linearGradient
                    id="linearGradient1345"
                    x1="233.122"
                    x2="2.24"
                    y1="56.015"
                    y2="242.78"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient1351"
                ></linearGradient>
            </defs>
            <circle
                id="circle38"
                cx="127.994"
                cy="127.994"
                r="123.111"
                fill="url(#linearGradient-3)"
                fillRule="nonzero"
                mask="url(#mask-2)"
            ></circle>
            <g id="g2266">
                <path
                    id="path42"
                    fill="url(#linearGradient-5)"
                    fillOpacity="1"
                    fillRule="nonzero"
                    d="M98.044 75.517c-1.751-.002-3.524.01-5.292.061-2.056.06-4.817.713-8 1.785 53.775 40.834 73.108 114.497 39.875 178.514 1.129.03 2.249.123 3.385.123 60.736 0 111.492-42.323 124.609-99.071-38.542-45.178-90.813-81.314-154.578-81.412z"
                    mask="url(#mask-2)"
                    opacity="0.75"
                ></path>
            </g>
            <path
                id="path44"
                fill="#1e4b7b"
                fillOpacity="1"
                fillRule="nonzero"
                d="M84.752 77.368C66.895 83.378 32.83 104.546.079 132.81c2.487 67.334 57.028 121.313 124.548 123.07 33.233-64.016 13.901-137.68-39.875-178.513z"
                mask="url(#mask-2)"
                opacity="0.75"
            ></path>
            <path
                id="path150"
                fill="url(#linearGradient1345)"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128.747 54.005c-10.985 5.495 0 27.466 0 27.466C95.774 108.954 102.78 155.9 64.312 155.9c-20.97 0-42.242-24.077-64.233-38.828-.283 3.479-.785 6.972-.785 10.524 0 48.095 26.263 89.924 65.42 111.897 10.952-1.38 22.838-4.114 31.05-9.592 43.146-28.765 53.857-83.491 71.487-109.925 10.979-16.492 62.434-15.061 65.906-22.01 5.502-10.991-10.99-27.467-16.491-27.467h-43.958c-3.071 0-7.897-5.456-10.974-5.456h-16.492s-7.307-11.085-13.794-11.526c-.93-.066-1.83.053-2.7.488z"
                mask="url(#mask-2-7)"
                transform="translate(-.769 -.133)"
            ></path>
            <path
                id="path40"
                fill="#2d4150"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128 256C57.308 256 0 198.692 0 128 0 57.308 57.308 0 128 0c70.692 0 128 57.308 128 128 0 70.692-57.308 128-128 128zm0-9.768c65.298 0 118.232-52.934 118.232-118.232S193.298 9.768 128 9.768 9.768 62.702 9.768 128 62.702 246.232 128 246.232z"
                mask="url(#mask-2)"
                transform="translate(-.59) scale(1.00078)"
            ></path>
        </svg>
    );
}

export function CamelIcon(props?: (React.SVGProps<SVGSVGElement>) | undefined) {
    return (<svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            preserveAspectRatio="xMidYMid"
            viewBox="0 0 256 256"
            {...props}
            className="icon" width="32px" height="32px">
            <defs>
                <linearGradient
                    id="b"
                    x1="-12.564%"
                    x2="101.304%"
                    y1="108.214%"
                    y2="-1.964%"
                >
                    <stop offset="0%" stopColor="#F69923"/>
                    <stop offset="10.996%" stopColor="#F79A23"/>
                    <stop offset="94.502%" stopColor="#E97826"/>
                </linearGradient>
                <linearGradient
                    id="d"
                    x1="-12.564%"
                    x2="101.304%"
                    y1="108.214%"
                    y2="-1.964%"
                >
                    <stop offset="0%" stopColor="#F69923"/>
                    <stop offset="8.048%" stopColor="#F79A23"/>
                    <stop offset="41.874%" stopColor="#E97826"/>
                </linearGradient>
                <linearGradient
                    id="e"
                    x1="74.724%"
                    x2="6.653%"
                    y1="-3.059%"
                    y2="100.066%"
                >
                    <stop offset="0%" stopColor="#F6E423"/>
                    <stop offset="41.191%" stopColor="#F79A23"/>
                    <stop offset="73.271%" stopColor="#E97826"/>
                </linearGradient>
                <circle id="a" cx={128} cy={128} r={128}/>
            </defs>
            <mask id="c" fill="#fff">
                <use xlinkHref="#a"/>
            </mask>
            <circle
                cx={127.994}
                cy={127.994}
                r={123.111}
                fill="url(#b)"
                mask="url(#c)"
            />
            <path
                fill="url(#d)"
                d="M128 256C57.308 256 0 198.692 0 128 0 57.308 57.308 0 128 0c70.692 0 128 57.308 128 128 0 70.692-57.308 128-128 128Zm0-9.768c65.298 0 118.232-52.934 118.232-118.232S193.298 9.768 128 9.768 9.768 62.702 9.768 128 62.702 246.232 128 246.232Z"
                mask="url(#c)"
            />
            <path
                fill="url(#e)"
                d="M98.044 75.517c-1.751-.002-3.524.01-5.292.061-2.056.06-4.817.713-8 1.785 53.775 40.834 73.108 114.497 39.875 178.514 1.129.03 2.249.123 3.385.123 60.736 0 111.492-42.323 124.609-99.071-38.542-45.178-90.813-81.314-154.578-81.412Z"
                mask="url(#c)"
                opacity={0.75}
            />
            <path
                fill="#28170B"
                d="M84.752 77.368C66.895 83.378 32.83 104.546.079 132.81c2.487 67.334 57.028 121.313 124.548 123.07 33.233-64.016 13.901-137.68-39.875-178.513Z"
                mask="url(#c)"
                opacity={0.75}
            />
            <path
                fill="#FFF"
                d="M128.747 54.005c-10.985 5.495 0 27.466 0 27.466C95.774 108.954 102.78 155.9 64.312 155.9c-20.97 0-42.242-24.077-64.233-38.828-.283 3.479-.785 6.972-.785 10.524 0 48.095 26.263 89.924 65.42 111.897 10.952-1.38 22.838-4.114 31.05-9.592 43.146-28.765 53.857-83.491 71.487-109.925 10.979-16.492 62.434-15.061 65.906-22.01 5.502-10.991-10.99-27.467-16.491-27.467h-43.958c-3.071 0-7.897-5.456-10.974-5.456h-16.492s-7.307-11.085-13.794-11.526c-.93-.066-1.83.053-2.7.488Z"
                mask="url(#c)"
            />
        </svg>
    );
}

export function getDesignerIcon(icon: string, className?: string): ReactElement {
    if (icon === 'kamelet') return (
        <svg
            className={`top-icon ${className}`} id="icon"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            width="32px" height="32px"
        >
            <title>{"application"}</title>
            <path
                d="M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2ZM6 6v10h10V6ZM26 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM26 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM16 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    )
    if (icon === 'code') return (
        <svg
            className={`top-icon ${className}`}
            xmlns="http://www.w3.org/2000/svg"
            width="24"
            height="24"
            fill="none"
            viewBox="0 0 24 24"
        >
            <path
                fill="#000000"
                d="M8.502 5.387a.75.75 0 00-1.004-1.115L5.761 5.836c-.737.663-1.347 1.212-1.767 1.71-.44.525-.754 1.088-.754 1.784 0 .695.313 1.258.754 1.782.42.499 1.03 1.049 1.767 1.711l1.737 1.564a.75.75 0 101.004-1.115l-1.697-1.527c-.788-.709-1.319-1.19-1.663-1.598-.33-.393-.402-.622-.402-.817 0-.196.072-.425.402-.818.344-.409.875-.889 1.663-1.598l1.697-1.527zM14.18 4.275a.75.75 0 01.532.918l-3.987 15a.75.75 0 11-1.45-.386l3.987-15a.75.75 0 01.918-.532zM15.443 10.498a.75.75 0 011.059-.055l1.737 1.563c.737.663 1.347 1.213 1.767 1.711.44.524.754 1.088.754 1.783 0 .695-.313 1.259-.754 1.783-.42.498-1.03 1.048-1.767 1.71l-1.737 1.565a.75.75 0 11-1.004-1.116l1.697-1.526c.788-.71 1.319-1.19 1.663-1.599.33-.392.402-.622.402-.817 0-.195-.072-.425-.402-.817-.344-.41-.875-.89-1.663-1.599l-1.697-1.527a.75.75 0 01-.055-1.059z"
            ></path>
        </svg>
    )
    if (icon === 'routes') return (
        <svg className={`top-icon ${className}`} width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <path
                d="M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"/>
            <path
                d="M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"/>
            <path
                d="M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none' width="32"
                  height="32"/>
        </svg>)
    if (icon === 'route') return (
        <svg className={`top-icon ${className}`} width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>{"category"}</title>
            <path
                d="M27 22.141V18a2 2 0 0 0-2-2h-8v-4h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2h-6a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v4H7a2 2 0 0 0-2 2v4.142a4 4 0 1 0 2 0V18h8v4.142a4 4 0 1 0 2 0V18h8v4.141a4 4 0 1 0 2 0ZM13 4h6l.001 6H13ZM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2Zm10 0a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2Zm8 2a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    )
    if (icon === 'rest') return (
        <svg className={`top-icon ${className}`} viewBox="0 0 32 32" width="32px" height="32px">
            <g className="layer">
                <title>Layer 1</title>
                <path
                    d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                    id="svg_1"/>
                <path
                    d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                    id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
            </g>
        </svg>
    )
    if (icon === 'beans') return (
        <svg className={`top-icon ${className}`} width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>data--1</title>
            <rect x="15" y="6" width="13" height="2"/>
            <rect x="15" y="24" width="13" height="2"/>
            <rect x="4" y="15" width="13" height="2"/>
            <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z" transform="translate(0 0)"/>
            <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z" transform="translate(0 0)"/>
            <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"
                  transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect fill='none' width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'dependencies') return (
        <svg className={`top-icon ${className}`} width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>application</title>
            <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"
                  transform="translate(0 0)"/>
            <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect fill='none' width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'error') return (
        <svg className={`top-icon ${className}`} width="36px" height="36px" viewBox="0 0 36 36" version="1.1"
             preserveAspectRatio="xMidYMid meet">
            <circle className="clr-i-outline clr-i-outline-path-1" cx="18" cy="26.06" r="1.33"/>
            <path className="clr-i-outline clr-i-outline-path-2"
                  d="M18,22.61a1,1,0,0,1-1-1v-12a1,1,0,1,1,2,0v12A1,1,0,0,1,18,22.61Z"/>
            <path className="clr-i-outline clr-i-outline-path-3"
                  d="M18,34A16,16,0,1,1,34,18,16,16,0,0,1,18,34ZM18,4A14,14,0,1,0,32,18,14,14,0,0,0,18,4Z"/>
            <rect x="0" y="0" width="36" height="36" fillOpacity="0"/>
        </svg>)
    if (icon === 'exception') return (
        <svg className={`top-icon ${className}`} width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>misuse--alt</title>
            <polygon
                points="21.41 23 16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23"/>
            <path d="M16,4A12,12,0,1,1,4,16,12.0136,12.0136,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z"
                  transform="translate(0)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none' width="32"
                  height="32"/>
        </svg>)
    if (icon === 'routeConfiguration') return (
        <svg className={`top-icon ${className}`} width="32" height="32" viewBox="0 0 32 32">
            <path
                d="M28.83 21.17L25 17.37l.67-.67a1 1 0 000-1.41l-6-6a1 1 0 00-1.41 0l-.79.79-6.76-6.79a1 1 0 00-1.41 0l-4 4-.12.15-4 6a1 1 0 00.12 1.26l3 3a1 1 0 001.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 000 1.41l2 2a1 1 0 00.71.3 1 1 0 00.52-.15l4.33-2.6 2.44 2.45a1 1 0 001.41 0l.67-.7 3.79 3.83a4 4 0 005.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 01-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 010 2.83z"></path>
            <path
                d="M0 0H32V32H0z"
                fill='none'
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>)
    if (icon === 'yaml') return (
        <svg className={`top-icon ${className}`} x="0px" y="0px" width="32px" height="32px"
             viewBox="0 0 32 32">
            <style type="text/css">{".st0{fill:none;}"}</style>
            <title>document</title>
            <path
                d="M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3  z M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"/>
            <rect x="10" y="22" width="12" height="2"/>
            <rect x="10" y="16" width="12" height="2"/>
            <rect className="st0" width="32" height="32"/>
        </svg>)
    if (icon === 'code') return (
        <svg className={`top-icon ${className}`} width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>code</title>
            <polygon points="31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"/>
            <polygon points="1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"/>
            <rect x="5.91" y="15" width="20.17" height="2" transform="translate(-3.6 27.31) rotate(-75)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none' width="32"
                  height="32" transform="translate(0 32) rotate(-90)"/>
        </svg>)
    return <></>;
}


export class BeanIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <title>data--1</title>
                <rect x="15" y="6" width="13" height="2"/>
                <rect x="15" y="24" width="13" height="2"/>
                <rect x="4" y="15" width="13" height="2"/>
                <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z"
                      transform="translate(0 0)"/>
                <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z"
                      transform="translate(0 0)"/>
                <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"
                      transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect fill='none' width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class DependencyIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <title>application</title>
                <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"
                      transform="translate(0 0)"/>
                <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect fill='none' width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class RestIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32">
                <g className="layer">
                    <title>Layer 1</title>
                    <path
                        d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                        id="svg_1"/>
                    <path
                        d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                        id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
                </g>
            </svg>
        )
    }
}

export class ConceptIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32">
                <title>concept</title>
                <path
                    d="M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"/>
                <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none'
                      width="32" height="32"/>
            </svg>
        )
    }
}

export function JKubeIcon(className?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 59.799997 68.099998"
            className={className ? className + " icon" : "icon"}
        >
            <style id="style1" type="text/css">
                {".jkube-icon-outer{fill-rule:evenodd;clip-rule:evenodd;fill:#0a4e9b}"}
            </style>
            <g id="g8" transform="translate(-9.2 -8.3)">
                <path
                    id="path6"
                    d="M9.3 59.8c.9.8 2.5 1.5 3.5 2.1l21.6 12.5c1 .6 2.5 1.6 3.6 2v-6.3L14.8 56.6V29.8c-1.6-.4-4.2-2.7-5.6-2.9Z"
                    className="jkube-icon-outer"
                />
                <path
                    id="path7"
                    d="m69 59.8-.1-33c-1.5.5-3.9 2.6-5.5 3v26.9c-.8.8-4.9 2.9-6.1 3.6l-12.3 7c-5.1 3-4.8 2-4.8 4.9l.1 4.2z"
                    className="jkube-icon-outer"
                />
                <path
                    id="path8"
                    d="M15.9 28c1.9-.7 4.3-2.4 6-3.4l5.7-3.3c2.1-1.2 3.7-2.2 5.8-3.4 1.7-.9 4.1-2.6 5.7-3.2l14.3 8.2c2.4 1.4 4.7 2.7 7.2 4.1 2.1 1.2 1.6 1 3.7-.1 1-.6 2.7-1.4 3.4-2.1-.7-.7-28.3-16.5-28.5-16.5-.2 0-27.8 15.7-28.7 16.6Z"
                    className="jkube-icon-outer"
                />
            </g>
            <path
                id="path9"
                d="M30 9.5 8.6 21.8v24.7L30 58.8l21.4-12.3V21.8Zm7.4 29c0 1.8-.5 3.6-1.4 5.1-.9 1.6-2.2 2.8-3.8 3.7-1.6.9-3.3 1.4-5.2 1.4-1.9 0-3.6-.5-5.2-1.4-1.6-.9-2.9-2.2-3.8-3.7-.9-1.6-1.4-3.3-1.4-5.1h6.8c0 .9.3 1.7 1 2.4s1.5 1 2.5 1 1.8-.3 2.5-1 1-1.5 1-2.4V28.2H24v-6.8h13.3v17.1z"
                style={{
                    fill: "#0a4e9b",
                }}
            />
        </svg>
    )
}

export function AsyncApiIcon({className = ''}) {
    return (
        <svg className={"h-10 mt-0.5 w-auto " + className} width="165" height="36" viewBox="0 0 165 36" fill="none" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <linearGradient id="gradient1" x1="33.0317" y1="3.3661" x2="4.57364" y2="32.1761" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#2DCCFD"></stop>
                    <stop offset="100%" stop-color="#AD20E2"></stop>
                </linearGradient>
                <linearGradient id="gradient2" x1="33.0317" y1="32.6313" x2="4.571" y2="3.82126" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#A829E2"></stop>
                    <stop offset="5%" stop-color="#A829E2" stop-opacity="84%"></stop>
                    <stop offset="11%" stop-color="#A829E2" stop-opacity="67%"></stop>
                    <stop offset="18%" stop-color="#A829E2" stop-opacity="51%"></stop>
                    <stop offset="25%" stop-color="#A829E2" stop-opacity="38%"></stop>
                    <stop offset="33%" stop-color="#A829E2" stop-opacity="28%"></stop>
                    <stop offset="43%" stop-color="#A829E2" stop-opacity="20%"></stop>
                    <stop offset="54%" stop-color="#A829E2" stop-opacity="14%"></stop>
                    <stop offset="68%" stop-color="#A829E2" stop-opacity="11%"></stop>
                    <stop offset="100%" stop-color="#A829E2" stop-opacity="10%"></stop>
                </linearGradient>
                <linearGradient id="gradient3" x1="3.41005" y1="32.6313" x2="31.8682" y2="3.82129" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#E50E99"></stop>
                    <stop offset="100%" stop-color="#A829E2" stop-opacity="10%"></stop>
                </linearGradient>
                <linearGradient id="gradient4" x1="33.0317" y1="3.36871" x2="4.57097" y2="32.1761" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#21D4FD"></stop>
                    <stop offset="3%" stop-color="#27CDFC" stop-opacity="96%"></stop>
                    <stop offset="23%" stop-color="#4E9CF4" stop-opacity="70%"></stop>
                    <stop offset="43%" stop-color="#6E73EE" stop-opacity="49%"></stop>
                    <stop offset="61%" stop-color="#8753E9" stop-opacity="32%"></stop>
                    <stop offset="77%" stop-color="#993CE5" stop-opacity="20%"></stop>
                    <stop offset="90%" stop-color="#A42EE3" stop-opacity="13%"></stop>
                    <stop offset="100%" stop-color="#A829E2" stop-opacity="10%"></stop>
                </linearGradient>
            </defs>
            <path
                d="M63.9815 27.6971H61.4524L59.3704 22.3187H50.4894L48.4074 27.6971H45.9074L53.5529 8.30026H56.3783L63.9815 27.6971ZM51.3386 20.1182H58.5079L54.9074 10.5635L51.3386 20.1182Z"
                fill="#0C0928"></path>
            <path
                d="M71.7037 27.9925C70.3161 28.0052 68.9453 27.6926 67.7037 27.0804C66.5264 26.5139 65.5472 25.6129 64.8915 24.4931L66.9154 23.0531C67.3281 23.9309 67.9957 24.6678 68.8333 25.17C69.7573 25.7002 70.8129 25.9645 71.881 25.9331C72.9392 25.9331 73.7566 25.7345 74.3519 25.332C74.5772 25.1976 74.771 25.0172 74.9202 24.8029C75.0695 24.5887 75.1707 24.3455 75.2173 24.0895C75.2639 23.8335 75.2547 23.5707 75.1903 23.3185C75.1259 23.0663 75.0078 22.8306 74.8439 22.6271C74.5741 22.2786 74.0635 22.0286 73.3122 21.877L69.7408 21.1348C68.291 20.8421 67.2549 20.3525 66.6323 19.6661C66.0004 18.9638 65.6644 18.0493 65.6931 17.1101C65.688 16.3206 65.9331 15.5493 66.3942 14.9044C66.9016 14.2043 67.5894 13.6512 68.3863 13.3024C69.3457 12.8822 70.3873 12.6769 71.4365 12.7013C72.7305 12.6615 74.0126 12.9561 75.1561 13.5559C76.148 14.1039 76.9395 14.9471 77.418 15.9654L75.4233 17.2722C75.1327 16.4626 74.5495 15.7878 73.7857 15.3774C73.0666 14.9839 72.2586 14.7762 71.4365 14.7737C70.8133 14.7596 70.1927 14.8588 69.6058 15.0664C69.1521 15.2272 68.7514 15.5073 68.4471 15.8766C68.1783 16.2134 68.0358 16.6318 68.044 17.0606C68.0522 17.4894 68.2106 17.9022 68.4921 18.2287C68.7884 18.5911 69.343 18.8524 70.1561 19.0127L73.8757 19.7784C75.2654 20.052 76.2355 20.5024 76.7857 21.1296C77.344 21.7637 77.6413 22.5815 77.619 23.4216C77.6361 24.2872 77.3759 25.136 76.8757 25.8468C76.3504 26.566 75.628 27.1218 74.7937 27.4489C73.8106 27.8314 72.7601 28.0163 71.7037 27.9925V27.9925Z"
                fill="#0C0928"></path>
            <path
                d="M90.3703 13.0018H92.9285L85.9391 30.1668C85.642 30.9811 85.2258 31.748 84.7037 32.4431C84.3138 32.9574 83.8037 33.3707 83.2169 33.6479C82.6214 33.9034 81.9771 34.0291 81.328 34.0164C80.6995 34.0219 80.0743 33.9275 79.4762 33.7367C78.939 33.565 78.4321 33.312 77.9735 32.9867L78.6269 30.9299C78.9951 31.2671 79.424 31.5331 79.8915 31.7139C80.3125 31.8803 80.7609 31.9689 81.2143 31.9753C81.7379 31.9722 82.2474 31.8077 82.6719 31.5049C83.127 31.1913 83.5432 30.5545 83.9206 29.5945L84.6931 27.684L83.2063 24.1873L78.4761 13.0175H81.1772L85.8174 24.2134L90.3703 13.0018Z"
                fill="#0C0928"></path>
            <path
                d="M94.9735 27.6971V13.0018H97.0502L97.2566 16.2947L96.8703 15.9707C97.1438 15.2501 97.5819 14.6017 98.1507 14.0759C98.6824 13.5968 99.3148 13.2398 100.003 13.0306C100.711 12.8158 101.449 12.7075 102.19 12.7091C103.193 12.6965 104.187 12.9017 105.101 13.3102C105.966 13.7045 106.695 14.3405 107.198 15.1396C107.727 15.9637 107.992 17.0091 107.992 18.2757V27.6841H105.611V19.1146C105.611 17.4891 105.258 16.3566 104.553 15.7172C103.842 15.079 102.91 14.7371 101.95 14.7633C101.207 14.7703 100.475 14.9408 99.8068 15.2624C99.0692 15.6187 98.4538 16.1812 98.037 16.8801C97.5714 17.6258 97.3386 18.625 97.3386 19.8777V27.6945L94.9735 27.6971Z"
                fill="#0C0928"></path>
            <path
                d="M117.251 12.7091C118.181 12.6912 119.105 12.851 119.974 13.1795C120.741 13.4831 121.436 13.9436 122.011 14.5307C122.599 15.1392 123.072 15.8474 123.407 16.6214L121.148 17.6668C120.895 16.8219 120.393 16.0705 119.706 15.5081C118.978 14.983 118.091 14.7185 117.19 14.758C116.291 14.7331 115.404 14.9625 114.632 15.4192C113.903 15.8776 113.332 16.5437 112.995 17.3297C112.243 19.2646 112.243 21.4057 112.995 23.3405C113.329 24.1319 113.9 24.8032 114.632 25.264C115.404 25.7207 116.291 25.9501 117.19 25.9252C117.877 25.9411 118.56 25.8211 119.198 25.5724C119.745 25.3515 120.226 24.9983 120.598 24.5453C120.979 24.0633 121.239 23.4991 121.357 22.8989L123.558 23.662C123.249 24.5153 122.779 25.3035 122.175 25.9853C121.591 26.6305 120.867 27.1378 120.058 27.4698C119.167 27.8283 118.211 28.006 117.249 27.9925C115.95 28.0139 114.667 27.6995 113.529 27.0804C112.433 26.4701 111.544 25.5548 110.971 24.4486C110.363 23.1655 110.048 21.7662 110.048 20.3495C110.048 18.9328 110.363 17.5334 110.971 16.2503C111.545 15.1447 112.434 14.2296 113.529 13.6186C114.668 12.9998 115.952 12.6862 117.251 12.7091Z"
                fill="#0C0928"></path>
            <path
                d="M143.659 27.6971H140.296L138.423 22.614H130.183L128.307 27.6971H125.034L132.442 8.30026H136.251L143.659 27.6971ZM131.074 20.0555H137.526L134.312 11.0052L131.074 20.0555Z"
                fill="#0C0928"></path>
            <path
                d="M152.992 8.30024C154.248 8.26933 155.494 8.52043 156.638 9.03462C157.616 9.49485 158.441 10.2199 159.019 11.1254C159.584 12.1193 159.881 13.2402 159.881 14.3804C159.881 15.5205 159.584 16.6415 159.019 17.6354C158.443 18.5428 157.617 19.2684 156.638 19.7262C155.495 20.2425 154.248 20.4945 152.992 20.4631H148.619V27.6919H145.444V8.30024H152.992ZM152.487 17.7635C153.898 17.7635 154.934 17.4743 155.595 16.8958C156.257 16.3174 156.589 15.4802 156.593 14.3843C156.593 13.2692 156.26 12.4216 155.595 11.8414C154.93 11.2613 153.894 10.972 152.487 10.9738H148.619V17.7687L152.487 17.7635Z"
                fill="#0C0928"></path>
            <path d="M165 8.30026V27.6971H161.825V8.30026H165Z" fill="#0C0928"></path>
            <path
                d="M27.8228 0H8.61905C3.85888 0 0 3.8121 0 8.51456V27.4854C0 32.1879 3.85888 36 8.61905 36H27.8228C32.5829 36 36.4418 32.1879 36.4418 27.4854V8.51456C36.4418 3.8121 32.5829 0 27.8228 0Z"
                fill="url(#gradient1)"></path>
            <path
                d="M27.8228 0H8.61905C3.85888 0 0 3.8121 0 8.51456V27.4854C0 32.1879 3.85888 36 8.61905 36H27.8228C32.5829 36 36.4418 32.1879 36.4418 27.4854V8.51456C36.4418 3.8121 32.5829 0 27.8228 0Z"
                fill="url(#gradient2)"></path>
            <path
                d="M27.8228 0H8.61905C3.85888 0 0 3.8121 0 8.51456V27.4854C0 32.1879 3.85888 36 8.61905 36H27.8228C32.5829 36 36.4418 32.1879 36.4418 27.4854V8.51456C36.4418 3.8121 32.5829 0 27.8228 0Z"
                fill="url(#gradient3)"></path>
            <path
                d="M27.8228 0H8.61905C3.85888 0 0 3.8121 0 8.51456V27.4854C0 32.1879 3.85888 36 8.61905 36H27.8228C32.5829 36 36.4418 32.1879 36.4418 27.4854V8.51456C36.4418 3.8121 32.5829 0 27.8228 0Z"
                fill="url(#gradient4)"></path>
            <path d="M11.7645 14.1988L10.6799 15.6754L19.1508 21.749L19.209 21.7908L20.2936 20.3142L11.8227 14.2406L11.7645 14.1988Z" fill="white"></path>
            <path d="M17.2989 14.2406L17.2407 14.1988L16.1561 15.6754L24.627 21.749L24.6852 21.7908L25.7698 20.3142L17.2989 14.2406Z" fill="white"></path>
            <path
                d="M18.2275 6.64075C13.6349 6.64075 9.89948 9.46064 9.89948 12.9261V12.9966H11.7513V12.9261C11.7513 10.4668 14.6614 8.46492 18.2328 8.46492C21.8042 8.46492 24.7143 10.4668 24.7143 12.9261V12.9966H26.5661V12.9261C26.5556 9.46064 22.8201 6.64075 18.2275 6.64075Z"
                fill="white"></path>
            <path
                d="M24.6958 23.0714C24.6958 25.5306 21.7857 27.5325 18.2116 27.5325C14.6376 27.5325 11.7301 25.5306 11.7301 23.0714V23.0008H9.8783V23.0714C9.8783 26.5368 13.6137 29.3567 18.2063 29.3567C22.7989 29.3567 26.5344 26.5368 26.5344 23.0714V23.0008H24.6825L24.6958 23.0714Z"
                fill="white"></path>
        </svg>
    );
}

export function OpenApiIcon(className?: string, height?: number | string | undefined, width?: number | string | undefined, fill?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlSpace="preserve"
            viewBox="0 0 112 112"
            height={height}
            width={width}
            className={className}
        >
            <path
                fill={fill ?? "#93d500"}
                d="M74.909 189.069H45.352c.005.144.009.289.017.433.012.278.032.555.049.833.008.119.013.238.022.356.023.322.051.642.08.962l.02.215a46.218 46.218 0 0 0 .126 1.168 43.62 43.62 0 0 0 .154 1.158c.339 2.356.848 4.69 1.527 6.984.003.01.007.019.009.029a43.315 43.315 0 0 0 .373 1.203c.105.323.215.645.325.968.029.081.056.163.086.244.099.279.2.558.304.837l.143.378.27.691c.069.173.141.346.213.519.074.18.15.359.226.54.094.22.192.439.289.658l.175.391c.12.263.244.526.368.787.041.084.08.168.122.252.145.301.293.599.443.895.025.046.047.091.07.137.169.328.341.656.518.981.008.014.016.028.023.044.037.068.078.133.115.2l25.243-15.207.093-.056a20.129 20.129 0 0 1-1.846-6.6z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#4d5a31"}
                d="m82.173 202.638-.071.071-20.819 20.82c.107.1.213.201.323.298.194.176.392.351.589.523.102.091.202.181.304.269.236.204.474.403.711.602l.192.16a47.32 47.32 0 0 0 .917.737 62.01 62.01 0 0 0 .928.711 50.044 50.044 0 0 0 3.895 2.633l.139.085c.255.153.51.304.767.453l.471.268c.148.086.296.168.446.251a63.783 63.783 0 0 0 .927.499c.757.396 1.527.764 2.303 1.118l.739-1.794 10.471-25.429.039-.094a20.195 20.195 0 0 1-3.271-2.181z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#6ba43a"}
                d="M80.005 200.564a20.653 20.653 0 0 1-1.767-2.28 21.467 21.467 0 0 1-.54-.843l-25.275 15.226c.388.645.793 1.273 1.206 1.894l.041.065.015.023c.014.02.026.042.04.063l.004.006.101.148.006.009.003.004c.439.649.89 1.288 1.355 1.91l.031.04.03.039a45.939 45.939 0 0 0 1.351 1.715l.158.191c.2.239.4.477.604.713.087.101.178.202.266.302.174.198.346.395.524.59.097.107.198.215.297.322l.135.146c.13.14.259.28.39.419.052.055.107.109.16.164.23.24.462.48.699.716l20.85-20.85a17.977 17.977 0 0 1-.684-.732z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#4d5a31"}
                d="M107.642 202.627c-.229.185-.461.366-.697.54l.052.087 15.202 25.235c.704-.46 1.4-.934 2.08-1.432a50.463 50.463 0 0 0 4.267-3.527l-20.821-20.821z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#93d500"}
                d="m74.961 105.035-.006.003.015-.008a.024.024 0 0 1-.009.005zM75.004 105.012c.066-.039.133-.072.198-.112-.065.04-.132.075-.198.112z"
            />
            <path
                fill={fill ?? "#93d500"}
                d="m119.99 228.696-.516-.856-14.19-23.555c-.287.173-.581.329-.874.487a20.15 20.15 0 0 1-9.528 2.404c-1.936 0-3.871-.28-5.742-.838-.319-.095-.63-.22-.945-.332-.315-.111-.634-.207-.944-.335l-10.464 25.412-.41.996-.351.853-.002.004.082.031.086.033h.001l.002.001.02.008c.247.101.496.188.744.285.311.121.622.244.934.358.159.058.317.126.476.182h.001a49.947 49.947 0 0 0 10.119 2.422c.135.016.269.035.404.054l.424.046c.266.03.531.061.798.087l.198.017c.327.031.654.059.979.082.111.008.223.013.333.021.287.019.572.037.858.05.175.01.35.015.526.021.227.008.453.017.682.024.327.008.657.011.986.012.078 0 .155.002.232.003a49.76 49.76 0 0 0 8.233-.686c.046-.007.091-.015.138-.021.288-.05.576-.104.864-.157l.491-.095.505-.106c.281-.059.561-.12.842-.185.05-.011.101-.021.152-.035a49.851 49.851 0 0 0 11.897-4.436l.001-.001c.246-.13.486-.278.731-.411.292-.16.582-.325.872-.491.201-.115.404-.221.603-.34l.001-.001.006-.004h.001l.009-.005.004-.003-.037-.063.037.063.006-.003.009-.005.033-.02.195-.117zM82.185 171.512c.23-.186.462-.366.697-.54l-.052-.087-15.201-25.235c-.706.461-1.404.936-2.085 1.436a49.645 49.645 0 0 0-4.262 3.522l20.821 20.821z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#4d5a31"}
                d="M59.838 151.994c-.237.237-.461.482-.692.722-.231.24-.466.479-.692.723a49.743 49.743 0 0 0-4.212 5.22c-.061.085-.122.174-.182.261a49.018 49.018 0 0 0-1.008 1.522 49.48 49.48 0 0 0-7.7 24.627c-.013.333-.02.667-.027 1-.007.333-.017.667-.017 1h29.488c0-.334.031-.666.048-1 .017-.334.022-.668.055-1a20.013 20.013 0 0 1 4.447-10.739c.21-.256.447-.496.672-.743.224-.247.432-.504.671-.742zM120.681 144.675l-.122-.073c-.259-.159-.521-.312-.783-.465-.152-.088-.304-.173-.457-.26-.154-.086-.306-.172-.461-.256-.266-.146-.533-.29-.801-.432l-.126-.066a49.592 49.592 0 0 0-6.649-2.878 49.774 49.774 0 0 0-9.936-2.358 58.984 58.984 0 0 0-.415-.056c-.139-.017-.277-.031-.415-.046a42.608 42.608 0 0 0-.801-.087c-.074-.007-.149-.012-.224-.02a50.991 50.991 0 0 0-.953-.08c-.123-.009-.248-.016-.371-.023-.272-.018-.547-.037-.819-.049-.146-.008-.29-.012-.434-.017l-.001 29.444v.115c1.517.157 3.02.48 4.478.975l21.754-21.754a48.287 48.287 0 0 0-2.464-1.614z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#6ba43a"}
                d="M93.914 137.485c-.333.007-.667.008-1 .021a49.856 49.856 0 0 0-6.233.643l-.136.023c-.29.05-.577.103-.865.157-.163.031-.327.061-.49.094-.17.034-.339.069-.508.106-.28.058-.56.119-.84.184l-.153.034a49.891 49.891 0 0 0-11.898 4.438h-.001c-.245.13-.484.277-.728.411-.292.16-.582.325-.872.491-.215.124-.434.238-.648.366l-.007.004h-.001l-.045.026c-.056.034-.114.062-.17.096l.003.005.516.857 14.705 24.412c.287-.173.581-.33.874-.487.295-.159.594-.308.895-.451a20.051 20.051 0 0 1 7.601-1.929c.333-.017.666-.034 1-.034l.001-29.487c-.334 0-.667.014-1 .02z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#4d5a31"}
                d="M144.458 184.631a53.77 53.77 0 0 0-.048-.795c-.008-.132-.015-.263-.026-.397a41.966 41.966 0 0 0-.077-.934c-.006-.081-.014-.161-.021-.242a60.396 60.396 0 0 0-.111-1.043l-.01-.084-.005-.04c-.046-.375-.096-.75-.149-1.124-.001-.011-.002-.025-.005-.035a49.558 49.558 0 0 0-1.524-6.972l-.014-.044c-.107-.356-.216-.71-.328-1.063-.015-.046-.031-.093-.045-.14a66.772 66.772 0 0 0-.412-1.212 50.701 50.701 0 0 0-.714-1.892c-.072-.18-.144-.357-.218-.534-.072-.176-.146-.35-.22-.526a80.106 80.106 0 0 0-.294-.671c-.056-.125-.112-.252-.17-.378a63.783 63.783 0 0 0-.373-.797l-.116-.242a58.592 58.592 0 0 0-.448-.906l-.065-.125c-.17-.331-.344-.663-.521-.99l-.019-.035a49.533 49.533 0 0 0-2.822-4.578l-21.761 21.762a20.5 20.5 0 0 1 .974 4.477h29.56c-.007-.149-.011-.295-.018-.44z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#6ba43a"}
                d="M115.03 187.069c0 .334-.031.666-.048 1-.016.334-.022.668-.055 1a20.022 20.022 0 0 1-4.446 10.74c-.21.256-.447.496-.672.743-.224.247-.432.504-.671.742l20.851 20.85c.237-.237.46-.482.691-.723.231-.241.466-.479.691-.723a49.783 49.783 0 0 0 4.224-5.236l.148-.214c.155-.223.306-.448.458-.673.133-.201.266-.402.395-.605.064-.097.128-.198.19-.295a49.46 49.46 0 0 0 7.685-24.607c.013-.333.02-.667.027-1 .007-.333.017-.666.017-1H115.03Z"
                style={{
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill={fill ?? "#424143"}
                d="M153.276 128.706c-5.395-5.395-14.142-5.395-19.536 0-4.304 4.303-5.164 10.736-2.601 15.902L101.048 174.7c-5.166-2.562-11.599-1.703-15.903 2.6-5.395 5.395-5.394 14.142 0 19.537 5.396 5.395 14.143 5.393 19.538-.001 4.303-4.303 5.162-10.736 2.599-15.903l30.091-30.091c5.167 2.562 11.599 1.703 15.902-2.601 5.395-5.392 5.395-14.14.001-19.535z"
                style={{
                    fill: fill ?? "#424143",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
        </svg>
    )
}