/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.undo.RemoveRelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.ProjectUtil;

public class RemoveRelationshipAction
extends RemoveAction
implements MultipleObjectsAction {
    private static final String ACTION_NAME = "Remove Relationship";
    private static final String ACTION_NAME_MULTIPLE = "Remove Relationships";

    public static String getActionName() {
        return ACTION_NAME;
    }

    @Override
    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public RemoveRelationshipAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return object instanceof Relationship;
    }

    @Override
    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        ProjectController mediator = this.getProjectController();
        ObjRelationship[] rels = this.getProjectController().getCurrentObjRelationships();
        if (rels != null && rels.length > 0) {
            if (rels.length == 1 && dialog.shouldDelete("ObjRelationship", rels[0].getName()) || rels.length > 1 && dialog.shouldDelete("selected ObjRelationships")) {
                ObjEntity entity = mediator.getCurrentObjEntity();
                this.removeObjRelationships(entity, rels);
                Application.getInstance().getUndoManager().addEdit(new RemoveRelationshipUndoableEdit(entity, rels));
            }
        } else {
            DbRelationship[] dbRels = this.getProjectController().getCurrentDbRelationships();
            if (dbRels != null && dbRels.length > 0 && (dbRels.length == 1 && dialog.shouldDelete("DbRelationship", dbRels[0].getName()) || dbRels.length > 1 && dialog.shouldDelete("selected DbRelationships"))) {
                DbEntity entity = mediator.getCurrentDbEntity();
                this.removeDbRelationships(entity, dbRels);
                Application.getInstance().getUndoManager().addEdit(new RemoveRelationshipUndoableEdit(entity, dbRels));
            }
        }
    }

    public void removeObjRelationships(ObjEntity entity, ObjRelationship[] rels) {
        ProjectController mediator = this.getProjectController();
        for (ObjRelationship rel : rels) {
            entity.removeRelationship(rel.getName());
            RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rel, (Entity)entity, 3);
            mediator.fireObjRelationshipEvent(e);
        }
    }

    public void removeDbRelationships(DbEntity entity, DbRelationship[] rels) {
        ProjectController mediator = this.getProjectController();
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = entity.getRelationship(rels[i].getName());
            entity.removeRelationship(rels[i].getName());
            RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rels[i], (Entity)entity, 3);
            mediator.fireDbRelationshipEvent(e);
        }
        ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
    }
}

