/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.util.Objects;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllPairIterator;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

final class Hll6Array
extends HllArray {
    Hll6Array(int lgConfigK) {
        super(lgConfigK, TgtHllType.HLL_6);
        this.hllByteArr = new byte[Hll6Array.hll6ArrBytes(lgConfigK)];
    }

    Hll6Array(Hll6Array that) {
        super(that);
    }

    static Hll6Array heapify(MemorySegment seg) {
        int lgConfigK = PreambleUtil.extractLgK(seg);
        Hll6Array hll6Array = new Hll6Array(lgConfigK);
        HllArray.extractCommonHll(seg, hll6Array);
        return hll6Array;
    }

    @Override
    Hll6Array copy() {
        return new Hll6Array(this);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int newValue = coupon >>> 26;
        int configKmask = (1 << this.lgConfigK) - 1;
        int slotNo = coupon & configKmask;
        this.updateSlotWithKxQ(slotNo, newValue);
        return this;
    }

    @Override
    int getNibble(int slotNo) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    int getSlotValue(int slotNo) {
        return Hll6Array.get6Bit(this.hllByteArr, 0, slotNo);
    }

    @Override
    PairIterator iterator() {
        return new HeapHll6Iterator(this, 1 << this.lgConfigK);
    }

    @Override
    void putNibble(int slotNo, int nibValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    void updateSlotNoKxQ(int slotNo, int newValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    void updateSlotWithKxQ(int slotNo, int newValue) {
        int oldValue = this.getSlotValue(slotNo);
        if (newValue > oldValue) {
            Hll6Array.put6Bit(this.hllByteArr, 0, slotNo, newValue);
            Hll6Array.hipAndKxQIncrementalUpdate(this, oldValue, newValue);
            if (oldValue == 0) {
                --this.numAtCurMin;
                assert (this.getNumAtCurMin() >= 0);
            }
        }
    }

    private static void put6Bit(byte[] arr, int offsetBytes, int slotNo, int newValue) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        int valShifted = (newValue & 0x3F) << shift;
        int curMasked = ByteArrayUtil.getShortLE(arr, byteIdx) & ~(63 << shift);
        short insert = (short)(curMasked | valShifted);
        ByteArrayUtil.putShortLE(arr, byteIdx, insert);
    }

    private static int get6Bit(byte[] arr, int offsetBytes, int slotNo) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        return (byte)(ByteArrayUtil.getShortLE(arr, byteIdx) >>> shift & 0x3F);
    }

    private final class HeapHll6Iterator
    extends HllPairIterator {
        int bitOffset;
        final /* synthetic */ Hll6Array this$0;

        HeapHll6Iterator(Hll6Array hll6Array, int lengthPairs) {
            Hll6Array hll6Array2 = hll6Array;
            Objects.requireNonNull(hll6Array2);
            this.this$0 = hll6Array2;
            super(lengthPairs);
            this.bitOffset = -6;
        }

        @Override
        int value() {
            this.bitOffset += 6;
            short tmp = ByteArrayUtil.getShortLE(this.this$0.hllByteArr, this.bitOffset / 8);
            int shift = this.bitOffset % 8 & 7;
            return tmp >>> shift & 0x3F;
        }
    }
}

