/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.view;

import grails.util.Environment;
import grails.util.GrailsUtil;
import groovy.text.Template;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.gsp.GroovyPageTemplate;
import org.grails.gsp.GroovyPageWritable;
import org.grails.gsp.GroovyPagesException;
import org.grails.gsp.GroovyPagesTemplateEngine;
import org.grails.web.pages.GSPResponseWriter;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.view.AbstractGrailsView;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;

public class GroovyPageView
extends AbstractGrailsView {
    private static final Log LOG = LogFactory.getLog(GroovyPageView.class);
    protected GroovyPagesTemplateEngine templateEngine;
    private long createTimestamp = System.currentTimeMillis();
    private static final long LASTMODIFIED_CHECK_INTERVAL = Long.getLong("grails.gsp.reload.interval", 5000L);
    private ScriptSource scriptSource;
    protected GroovyPageTemplate template;
    public static final String EXCEPTION_MODEL_KEY = "exception";
    private static boolean developmentMode = Environment.isDevelopmentMode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderTemplate(Map<String, Object> model, GrailsWebRequest webRequest, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("org.grails.rendering.view", (Object)Boolean.TRUE);
        try (GSPResponseWriter out = null;){
            out = this.createResponseWriter(webRequest, response);
            GroovyPageWritable writable = this.template.make(model);
            writable.setShowSource(developmentMode && request.getParameter("showSource") != null);
            writable.writeTo(out);
        }
    }

    protected void handleException(Exception exception, GroovyPagesTemplateEngine engine) {
        GrailsUtil.deepSanitize(exception);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Error processing GroovyPageView: " + exception.getMessage(), exception);
        }
        if (exception instanceof GroovyPagesException) {
            throw (GroovyPagesException)exception;
        }
        if (engine == null) {
            throw new GroovyPagesException("Error processing GroovyPageView: " + exception.getMessage(), (Throwable)exception, -1, this.getUrl());
        }
        throw GroovyPageView.createGroovyPageException(exception, engine, this.getUrl());
    }

    public static GroovyPagesException createGroovyPageException(Exception exception, GroovyPagesTemplateEngine engine, String pageUrl) {
        String file;
        int[] lineNumbers;
        GroovyPageTemplate t = (GroovyPageTemplate)engine.createTemplate(pageUrl);
        StackTraceElement[] stackTrace = exception.getStackTrace();
        String className = stackTrace[0].getClassName();
        int lineNumber = stackTrace[0].getLineNumber();
        if (className.contains("_gsp") && lineNumber < (lineNumbers = t.getMetaInfo().getLineNumbers()).length) {
            lineNumber = lineNumbers[lineNumber - 1];
        }
        Resource resource = pageUrl != null ? engine.getResourceForUri(pageUrl) : null;
        try {
            file = resource != null && resource.exists() ? resource.getFile().getAbsolutePath() : pageUrl;
        }
        catch (IOException e) {
            file = pageUrl;
        }
        return new GroovyPagesException("Error processing GroovyPageView: " + exception.getMessage(), (Throwable)exception, lineNumber, file);
    }

    protected GSPResponseWriter createResponseWriter(GrailsWebRequest webRequest, HttpServletResponse response) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)response);
        webRequest.setOut(out);
        return out;
    }

    public void setTemplateEngine(GroovyPagesTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.createTimestamp > LASTMODIFIED_CHECK_INTERVAL;
    }

    public void setScriptSource(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        try {
            this.initTemplate();
        }
        catch (Exception e) {
            this.handleException(e, this.templateEngine);
        }
    }

    protected void initTemplate() throws IOException {
        if (this.template == null) {
            this.template = this.scriptSource == null ? (GroovyPageTemplate)this.templateEngine.createTemplate(this.getUrl()) : (GroovyPageTemplate)this.templateEngine.createTemplate(this.scriptSource);
        }
        if (this.template != null) {
            this.template.setAllowSettingContentType(true);
        }
    }

    @Override
    public void rethrowRenderException(Throwable ex, String message) {
        throw new GroovyPagesException(message, ex);
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = (GroovyPageTemplate)template;
    }

    @Override
    protected boolean isUrlRequired() {
        return this.template == null;
    }
}

